package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenHasGenericType;
import de.fhdw.wtf.generator.java.generatorModel.GenHasNoGenericType;

/**
 * This visitor handles all GenericTypeState-types and returns values.
 * 
 * @param <X>
 *            The type of values returned by handle-methods.
 */
public interface GenericTypeStateVisitorReturn<X> {
	
	/**
	 * Handle method for objects of GenException-type.
	 * 
	 * @param hasType
	 *            GenException to handle.
	 * @return Value of type X
	 */
	X handle(GenHasGenericType hasType);
	
	/**
	 * Handle method for objects of GenHasNoGenericType-type.
	 * 
	 * @param hasNoType
	 *            GenHasNoGenericType to handle.
	 * @return Value of type X
	 */
	X handle(GenHasNoGenericType hasNoType);
}
