package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenAdvice;
import de.fhdw.wtf.generator.java.generatorModel.GenClassMember;
import de.fhdw.wtf.generator.java.generatorModel.GenJoinpoint;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenType;

/**
 * This visitor handles all GenerationModelItem-types.
 */
public interface GenerationModelItemVisitor {
	
	/**
	 * Handle method for objects of GenClassMember-type.
	 * 
	 * @param classMember
	 *            GenClassMember to handle.
	 */
	void handle(GenClassMember classMember);
	
	/**
	 * Handle method for objects of GenParameter-type.
	 * 
	 * @param parameter
	 *            GenParameter to handle.
	 */
	void handle(GenParameter parameter);
	
	/**
	 * Handle method for objects of GenType-type.
	 * 
	 * @param type
	 *            GenType to handle.
	 */
	void handle(GenType type);
	
	/**
	 * Handle method for objects of GenAdvice-type.
	 * 
	 * @param advice
	 *            GenAdvice to handle.
	 */
	void handle(GenAdvice advice);
	
	/**
	 * Handle method for objects of GenJoinpoint-type.
	 * 
	 * @param joinpoint
	 *            GenJoinpoint to handle.
	 */
	void handle(GenJoinpoint joinpoint);
}
