package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;

/**
 * This visitor handles all GenOperationState-types.
 */
public interface GenOperationStateVisitor {
	
	/**
	 * Handle method for objects of GenSimpleOperationState-type.
	 * 
	 * @param s
	 *            GenSimpleOperationState to handle.
	 */
	void handle(GenSimpleOperationState s);
	
	/**
	 * Handle method for objects of GenFullParsedOperationState-type.
	 * 
	 * @param s
	 *            GenFullParsedOperationState to handle.
	 */
	void handle(GenFullParsedOperationState s);
}
