package de.fhdw.wtf.generator.java.generatorModel;

import java.util.Collection;

import de.fhdw.wtf.generator.java.visitor.GenAttributeVisitorReturn;

public final class GenJavaAttribute extends GenAttribute {
	
	private GenJavaAttribute(final String name,
			final GenVisibility visibility,
			final GenTypeReference typ,
			final Collection<GenAttributeModifier> modifiers) {
		super(name, visibility, typ, modifiers);
	}
	
	public static GenJavaAttribute create(final String name,
			final GenVisibility visibility,
			final GenType typ,
			final Collection<GenAttributeModifier> modifiers) {
		return new GenJavaAttribute(name, visibility, GenTypeReferenceByReference.create(typ), modifiers);
	}
	
	public static GenJavaAttribute create(final String name,
			final GenVisibility visibility,
			final GenTypeReference typ,
			final Collection<GenAttributeModifier> modifiers) {
		return new GenJavaAttribute(name, visibility, typ, modifiers);
	}
	
	@Override
	public <T> T accept(final GenAttributeVisitorReturn<T> visitor) {
		return visitor.handleJavaAttribute(this);
	}
	
}
