package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenIntegerType;
import de.fhdw.wtf.generator.java.generatorModel.GenStringType;
import de.fhdw.wtf.generator.java.generatorModel.GenVoidType;

/**
 * This visitor handles all GenPrimitiveType-types.
 */
public interface GenPrimitiveTypeVisitor {
	
	/**
	 * Handle method for objects of GenIntegerType-type.
	 * 
	 * @param integerType
	 *            GenIntegerType to handle.
	 */
	void handle(GenIntegerType integerType);
	
	/**
	 * Handle method for objects of GenStringType-type.
	 * 
	 * @param stringType
	 *            GenStringType to handle.
	 */
	void handle(GenStringType stringType);
	
	/**
	 * Handle method for objects of GenVoidType-type.
	 * 
	 * @param voidType
	 *            GenVoidType to handle.
	 */
	void handle(GenVoidType voidType);
	
}
