package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import java.util.Collection;
import java.util.Vector;

import de.fhdw.wtf.common.ast.Attribute;
import de.fhdw.wtf.common.ast.ConstructorOrOperation;
import de.fhdw.wtf.common.ast.Group;
import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.java.generatorModel.GenAspect;
import de.fhdw.wtf.generator.java.generatorModel.GenAspectAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenAspectOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenClassModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReferenceByReference;
import de.fhdw.wtf.generator.java.generatorModel.GenUnqualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;

public class FinderTransformer extends Transformer {
	
	private final Collection<GenAspectOperation> findOperations;
	
	public FinderTransformer(final Model m, final TaskExecutor taskmanager, final GeneratorModel generatorModel) {
		super(m, taskmanager, generatorModel);
		this.findOperations = new Vector<>();
	}
	
	@Override
	public void handleClass(final ClassType c) throws TaskException {
		// nothing to do
	}
	
	@Override
	public void handleGroup(final Group g) throws TaskException {
		// nothing to do
	}
	
	@Override
	public void handleAttribute(final Attribute a, final ClassType owner) throws TaskException {
		// TODO finder method and comment
		if (a.isFindable()) {
			final de.fhdw.wtf.generator.java.generatorModel.GenClass genOwner =
					this.getGeneratorModel().getJavaClassForWTFClass(owner);
			final Vector<GenParameter> param = new Vector<>();
			final de.fhdw.wtf.generator.java.generatorModel.GenClass attrType =
					this.getGeneratorModel().getJavaClassForWTFClass(a.getAttrType());
			param.add(GenParameter.create("findBy", attrType));
			final Vector<GenOperationModifier> modifiers = new Vector<>();
			modifiers.add(GenOperationModifier.STATIC);
			final GenTypeReferenceByReference ref = GenTypeReferenceByReference.create(genOwner);
			final GenFullParsedOperationState state =
					GenFullParsedOperationState.create(
							GenComment.createFromPlainText("Commi", true),
							new Vector<GenException>(),
							ref,
							modifiers,
							GenVisibility.PUBLIC,
							"Operation");
			final GenAspectOperation currentOp =
					GenAspectOperation.create("find" + owner.getName() + "By" + a.getName(), param, state, genOwner);
			this.findOperations.add(currentOp);
		}
	}
	
	@Override
	public void handleConstructorOrOperation(final ConstructorOrOperation coo, final ClassType owner)
			throws TaskException {
		// TODO Please implement if necessary! (handleConstructor)
		
	}
	
	@Override
	public void finalizeTask() throws TaskException {
		// TODO finder class comment and package
		final GenUnqualifiedPackage aspectPackage = GenUnqualifiedPackage.create("iwo");
		final GenAspect finderAspect =
				GenAspect.create(
						"FinderAspect",
						new Vector<GenJavaOperation>(),
						this.findOperations,
						new Vector<GenInterfaceClass>(),
						new Vector<GenJavaAttribute>(),
						new Vector<GenAspectAttribute>(),
						new Vector<GenClassModifier>(),
						new Vector<GenJavaOperation>(),
						null,
						aspectPackage,
						GenComment.createFromPlainText("Commi", false),
						"");
		this.getGeneratorModel().addNonAstClass(finderAspect);
	}
	
	@Override
	public void beginTask() throws TaskException {
		// Nothing
	}
	
}
