/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.writer.writer;

import de.fhdw.wtf.file.FileUtils;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.writer.writer.ClassFileWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class FileHeaderWriter {
    private final ClassFileWriter classFileWriter;
    private static final String PACKAGE_KEY = "package";
    private static final String IMPORTS_KEY = "imports";
    private static final String GEN_CLASS_KEY = "genclass";
    private static final char JAVA_LINE_END = ';';
    private static final char PACKAGE_PATH_SEP = '.';
    private static final char FILE_PATH_SEP = '/';
    private static final String TEMPLATE_FILE_NAME = "de/fhdw/wtf/generator/templates/fileheader.vm";
    private final Context context = new VelocityContext();
    private final Template template;
    private final VelocityEngine engine;

    public FileHeaderWriter(ClassFileWriter classFileWriter) {
        this.classFileWriter = classFileWriter;
        this.engine = new VelocityEngine();
        this.engine.setProperty("resource.loader", (Object)"classpath");
        this.engine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        this.engine.init();
        this.template = this.engine.getTemplate(TEMPLATE_FILE_NAME);
    }

    public void writeGenClass(GenClass genclass, File rootDir) {
        this.setUpContext(genclass);
        this.writeToFile(genclass, rootDir);
    }

    private void setUpContext(GenClass c) {
        this.setPackage(c, this.context);
        this.setImports(c, this.context);
        this.setGenClass(c, this.context);
    }

    private void writeToFile(GenClass c, File rootDir) {
        String result = this.generateFileContent(this.context);
        File path = this.createPath(c, rootDir);
        File file = this.createFile(path, c);
        this.writeFile(result, path, file);
    }

    private String generateFileContent(Context context) {
        StringWriter writer = new StringWriter();
        this.template.merge(context, (Writer)writer);
        return writer.toString();
    }

    private File createPath(GenClass c, File rootDir) {
        String path = c.getPackag().toString();
        path = path.replace('.', '/');
        path = path.replace(';', '/');
        return new File(rootDir.getAbsolutePath() + '/' + path);
    }

    private File createFile(File path, GenClass c) {
        String file = path.getAbsolutePath() + '/' + c.getName() + c.getFileEnding();
        return new File(file);
    }

    private void writeFile(String result, File path, File file) {
        try {
            System.out.println("  -->  " + file.getAbsolutePath());
            FileUtils.overrideToFile(result, path, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setImports(GenClass c, Context context) {
        context.put(IMPORTS_KEY, (Object)c.getImports());
    }

    private void setPackage(GenClass c, Context context) {
        context.put(PACKAGE_KEY, (Object)(c.getPackag().toString() + ';'));
    }

    private void setGenClass(GenClass c, Context context) {
        context.put(GEN_CLASS_KEY, (Object)this.classFileWriter.getStringContent(c));
    }
}

