package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenPrimitiveTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenPrimitiveTypeVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorReturn;

/**
 * A GenPrimitiveType represents BaseTypes of WTF.
 */
public abstract class GenPrimitiveType extends GenType {
	
	/**
	 * The package where the class lies that represents this type.
	 */
	public static final String BASE_PACKAGE = "de.fhdw.wtf.context.model.";
	
	/**
	 * Instantiates a new GenPrimitiveType.
	 * 
	 * @param name
	 *            The Name of the primitive type.
	 */
	protected GenPrimitiveType(final String name) {
		super(name);
	}
	
	@Override
	public String getFullyQualifiedTypeNameWithGenericArguments() {
		return this.getFullyQualifiedTypeName();
	}
	
	@Override
	public void accept(final GenTypeVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenTypeVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
	
	@Override
	public <X extends java.lang.Exception> void accept(final GenTypeVisitorException<X> visitor) throws X {
		visitor.handle(this);
	}
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 */
	public abstract void accept(final GenPrimitiveTypeVisitor visitor);
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <X>
	 *            The returntype of the handle and the accept method.
	 * @return Returns the result of type <X> that is returned by the handle method.
	 */
	public abstract <X> X accept(final GenPrimitiveTypeVisitorReturn<X> visitor);
}
