/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.clipper.internal;

import de.fhdw.wtf.generator.transformer.clipper.ClipperUtils;
import de.fhdw.wtf.generator.transformer.exception.ClipperImportFormatException;
import java.util.ArrayList;
import java.util.List;

public class ClipperJavaFileShadowCopy {
    protected String content = "";
    protected String fullClass = "";
    protected String type = "";
    protected String name = "";
    protected List<ClipperJavaFileShadowCopy> innerClasses = new ArrayList<ClipperJavaFileShadowCopy>();

    private String getWhitespaces(int count) {
        return new String(new char[count]).replace('\u0000', ' ');
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return this.content;
    }

    public String getFullClass() {
        return this.fullClass;
    }

    public List<ClipperJavaFileShadowCopy> getInnerClasses() {
        return this.innerClasses;
    }

    public void analyze(String baseClassContent) throws ClipperImportFormatException {
        String tmpCopy = ClipperUtils.simplifyJavaCode(baseClassContent);
        if (baseClassContent.indexOf("class ") > -1 || baseClassContent.indexOf("interface ") > -1) {
            this.parseType(tmpCopy);
            this.parseName(tmpCopy);
            int idxOpen = tmpCopy.indexOf(123);
            int idxClose = ClipperUtils.findCorrespondingClosingCurlyBracket(idxOpen, tmpCopy);
            String strContentOfThisClass = baseClassContent.substring(idxOpen + 1, idxClose);
            this.content = this.parseInnerClasses(strContentOfThisClass);
            this.fullClass = baseClassContent.substring(0, idxOpen + 1) + "\n" + this.content + "}";
        } else {
            this.fullClass = baseClassContent;
        }
    }

    private String parseInnerClasses(String baseClassContent) throws ClipperImportFormatException {
        String result = baseClassContent;
        String resultShadow = ClipperUtils.simplifyJavaCode(baseClassContent);
        int idxOpen = resultShadow.indexOf(123);
        while (idxOpen > -1) {
            int idxClose = ClipperUtils.findCorrespondingClosingCurlyBracket(idxOpen, resultShadow);
            int idxNL = resultShadow.substring(0, idxOpen).lastIndexOf(10);
            String subClass = result.substring(idxNL + 1, idxClose + 1);
            result = result.substring(0, idxNL) + result.substring(idxClose + 1);
            resultShadow = resultShadow.substring(0, idxNL) + resultShadow.substring(idxClose + 1);
            idxOpen = resultShadow.indexOf(123);
            ClipperJavaFileShadowCopy inner = new ClipperJavaFileShadowCopy();
            inner.analyze(subClass);
            this.getInnerClasses().add(inner);
        }
        return result;
    }

    private void parseName(String shadowFile) throws ClipperImportFormatException {
        int idxOpen = shadowFile.indexOf(123);
        String subStr = shadowFile.substring(shadowFile.indexOf(this.getType()) + this.getType().length(), idxOpen).trim();
        if (subStr.contains(" ")) {
            subStr = subStr.split(" ")[0];
        }
        this.setName(subStr);
    }

    private void parseType(String shadowFile) throws ClipperImportFormatException {
        int idxOpen = shadowFile.indexOf(123);
        int idxInterface = shadowFile.substring(0, idxOpen).indexOf(" interface ");
        int idxClass = shadowFile.substring(0, idxOpen).indexOf(" class ");
        if (idxInterface > -1 && idxClass > -1) {
            if (idxInterface > idxClass) {
                this.setType("class");
            } else {
                this.setType("interface");
            }
        } else if (idxInterface > -1 && idxClass == -1) {
            this.setType("interface");
        } else if (idxClass > -1 && idxInterface == -1) {
            this.setType("class");
        } else if (idxClass == -1 && idxInterface == -1) {
            throw new ClipperImportFormatException("Bezeichnung 'class' und 'interface' nicht gefunden!");
        }
    }
}

