package de.fhdw.wtf.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;

/**
 * Iterator for {@link File}s. It reads the file line by line and returns the lines.
 */
public class FileIterator implements AutoCloseable {
	
	/**
	 * BufferedReader for reading the file.
	 */
	private final BufferedReader reader;
	
	/**
	 * List of lines of the file.
	 */
	private final LinkedList<String> nextlines;
	
	/**
	 * Constructor of {@link FileIterator}.
	 * 
	 * @param file
	 *            file
	 * @throws FileNotFoundException
	 *             possible Exceptions
	 */
	public FileIterator(final File file) throws FileNotFoundException {
		this.reader = new BufferedReader(new FileReader(file));
		this.nextlines = new LinkedList<>();
	}
	
	@Override
	public void close() throws IOException {
		this.reader.close();
	}
	
	/**
	 * Returns <true> if the file has at least one more line.
	 * 
	 * @return Boolean
	 */
	public boolean hasNext() {
		String next = null;
		try {
			next = this.reader.readLine();
			if (next != null) {
				this.nextlines.addLast(next);
			}
		} catch (final IOException e) {
			e.printStackTrace();
		}
		return !this.nextlines.isEmpty();
	}
	
	/**
	 * Returns the next line of the file.
	 * 
	 * @return next line
	 */
	public String next() {
		return this.nextlines.poll();
	}
}
