package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import java.util.Vector;

import de.fhdw.wtf.common.exception.walker.CyclicDependencyException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.DependencyTask;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.facade.PackageConstants;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenImportType;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenUnqualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.java.generatorModel.GenVoidType;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.java.walker.SimpleGeneratorModelWalkerTask;

/**
 * Generates the ApplicationStarter class into the {@link GeneratorModel} that is used to initialize all Factory classes
 * for all userdefined Types.<br>
 * The generates class contains the following operations where ... is variable <br>
 * 
 * <pre>
 * <code>
 * 	protected String getModelPrefix() {
 * 		...
 * 	}	
 * 	protected String getApplicationConfigFileName() {
 * 		...
 * 	}	
 * 	protected String getDatabaseConfigFileName() {
 * 		...
 * 	}	
 * 	protected String getResourcesPath() {
 * 		...
 * 	}	
 * 	protected void registerTypeFactories(de.fhdw.wtf.context.core.ObjectFactoryProvider objectFactoryProvider, de.fhdw.wtf.persistence.facade.TypeManager typeManager) {
 * 		try {
 * 			objectFactoryProvider.registerTypeFactory(typeManager, ... , new ...Factory());
 * 			... For any Usertype ...
 * 		}catch (de.fhdw.wtf.persistence.exception.TypeOrAssociationNotFoundException e) {e.printStackTrace();}
 * 	}</code>
 * </pre>
 * 
 */
public class AppStarterTransformer extends SimpleGeneratorModelWalkerTask {
	
	private static final String NEW_LINE = "\n";
	private final StringBuilder method;
	
	public AppStarterTransformer(final TaskExecutor taskmanager,
			final GeneratorModel javaGeneratorModel,
			final DependencyTask inheritanceTransformer) {
		super(taskmanager, javaGeneratorModel);
		this.method = new StringBuilder();
		this.method.append("try {");
		this.method.append(NEW_LINE);
		
		try {
			this.addDependency(inheritanceTransformer);
		} catch (final CyclicDependencyException e) {
			// should not happen
			e.printStackTrace();
			throw new Error("Dependency tasks are cyclic in AppStarterTransformer.");
		}
	}
	
	@Override
	public void handleClassClass(final GenClassClass cc) throws TaskException {
		if (!cc.getModifieres().contains(GenClassModifier.ABSTRACT)
				&& (cc.getFullyQualifiedTypeName().startsWith("generated.model.") || cc.getFullyQualifiedTypeName()
						.startsWith("generated.products."))) {
			AppStarterTransformer.this.generateFactoryRegistrationCall(cc, cc);
		}
	}
	
	/**
	 * Adds the line that initialize the Factory of the current cc at the methodbody of operation.
	 */
	@Override
	public void handleInterfaceClass(final GenInterfaceClass ic) throws TaskException {
		ic.accept(new GenInterfaceClassVisitorException<TaskException>() {
			
			@Override
			public void handle(final GenSimpleInterfaceClass simpleInterface) throws TaskException {
				// nothing to do
			}
			
			@Override
			public void handle(final GenInterfaceWithClassImplClass interfaceWithImplClass) throws TaskException {
				final GenClassClass cc = interfaceWithImplClass.getClassRepresentation();
				if (!cc.getModifieres().contains(GenClassModifier.ABSTRACT)) {
					AppStarterTransformer.this.generateFactoryRegistrationCall(interfaceWithImplClass, cc);
				}
			}
			
			@Override
			public void handle(final GenExternalInterfaceClass iface) {
				// nothing to do
			}
		});
	}
	
	/**
	 * Adds a call to register a factory for objects of some class.
	 * 
	 * @param iface
	 *            The interface class.
	 * @param impl
	 *            The implementation class. May be equal to {@link iface}.
	 */
	private void generateFactoryRegistrationCall(final GenClass iface, final GenClass impl) {
		this.method.append("\t\t\tobjectFactoryProvider.registerTypeFactory(typeManager, \""
				+ impl.getFullyQualifiedTypeName() + "\", new generated.factories." + iface.getName() + "Factory());");
		this.method.append(NEW_LINE);
	}
	
	/**
	 * Creates the GeneratedApplicationStartera and adds it to the {@link GeneratorModel}.
	 */
	@Override
	public void finalizeTask() throws TaskException {
		this.method
				.append("\t\t}catch (de.fhdw.wtf.persistence.exception.TypeOrAssociationNotFoundException e) {e.printStackTrace();}");
		GenPackage packag = GenUnqualifiedPackage.create("de");
		packag = packag.addName("fhdw");
		packag = packag.addName("wtf");
		packag = packag.addName("context");
		packag = packag.addName("core");
		final GenUserClass superC =
				GenUserClass.create(
						"ApplicationStarter",
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						new Vector<GenJavaAttribute>(),
						new Vector<GenClassModifier>(),
						new Vector<GenJavaOperation>(),
						null,
						packag,
						GenComment.createFromPlainText("", false),
						"");
		final GenUserClass appStarter =
				GenUserClass.create(
						"GeneratedApplicationStarter",
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						new Vector<GenJavaAttribute>(),
						new Vector<GenClassModifier>(),
						new Vector<GenJavaOperation>(),
						superC,
						PackageConstants.APPLICATION_PACKAGE,
						GenComment.createFromPlainText("Kommi", false),
						"");
		final GenJavaOperation registerTypeFactories =
				GenJavaOperation.create(
						"registerTypeFactories",
						GenVisibility.PROTECTED,
						new Vector<GenParameter>(),
						new Vector<GenException>(),
						this.method.toString(),
						GenVoidType.getInstance(),
						new Vector<GenOperationModifier>(),
						GenComment.create("@Override"));
		registerTypeFactories.getParameters().add(
				GenParameter.create(
						"objectFactoryProvider",
						GenImportType.create("de.fhdw.wtf.context.core.ObjectFactoryProvider")));
		registerTypeFactories.getParameters().add(
				GenParameter.create("typeManager", GenImportType.create("de.fhdw.wtf.persistence.facade.TypeManager")));
		final GenJavaOperation getResourcesPathJava =
				GenJavaOperation.create(
						"getResourcesPathJava",
						GenVisibility.PROTECTED,
						new Vector<GenParameter>(),
						new Vector<GenException>(),
						"return \"src/main/resources\";",
						GenImportType.create("String"),
						new Vector<GenOperationModifier>(),
						GenComment.create("@Override"));
		final GenJavaOperation getResourcesPathServer =
				GenJavaOperation.create(
						"getResourcesPathServer",
						GenVisibility.PROTECTED,
						new Vector<GenParameter>(),
						new Vector<GenException>(),
						"return \"WEB-INF\";",
						GenImportType.create("String"),
						new Vector<GenOperationModifier>(),
						GenComment.create("@Override"));
		final GenJavaOperation getApplicationConfigFileName =
				GenJavaOperation.create(
						"getApplicationConfigFileName",
						GenVisibility.PROTECTED,
						new Vector<GenParameter>(),
						new Vector<GenException>(),
						"return \"config/application.properties\";",
						GenImportType.create("String"),
						new Vector<GenOperationModifier>(),
						GenComment.create("@Override"));
		final GenJavaOperation getDatabaseConfigFileName =
				GenJavaOperation.create(
						"getDatabaseConfigFileName",
						GenVisibility.PROTECTED,
						new Vector<GenParameter>(),
						new Vector<GenException>(),
						"return \"config/oracledb.properties\";",
						GenImportType.create("String"),
						new Vector<GenOperationModifier>(),
						GenComment.create("@Override"));
		final GenJavaOperation getModelPrefix =
				GenJavaOperation.create(
						"getModelPrefix",
						GenVisibility.PROTECTED,
						new Vector<GenParameter>(),
						new Vector<GenException>(),
						"return \"generated.model\";",
						GenImportType.create("String"),
						new Vector<GenOperationModifier>(),
						GenComment.create("@Override"));
		final GenJavaOperation registerActivities =
				GenJavaOperation.create(
						"registerActivities",
						GenVisibility.PROTECTED,
						new Vector<GenParameter>(),
						new Vector<GenException>(),
						"",
						GenImportType.create("void"),
						new Vector<GenOperationModifier>(),
						GenComment.create("@Override"));
		appStarter.addOperation(getModelPrefix);
		appStarter.addOperation(getApplicationConfigFileName);
		appStarter.addOperation(getDatabaseConfigFileName);
		appStarter.addOperation(getResourcesPathJava);
		appStarter.addOperation(registerTypeFactories);
		appStarter.addOperation(getResourcesPathServer);
		appStarter.addOperation(registerActivities);
		this.getGeneratorModel().addNonAstClass(appStarter);
	}
	
	@Override
	public String toString() {
		return "ApplicationStarter generation";
	}
	
	@Override
	public void handleOperation(final GenOperation o) throws TaskException {
		// nothing to do
	}
}
