/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.generatorModel.GenImportType;
import de.fhdw.wtf.generator.java.generatorModel.GenParameterModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenType;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReference;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReferenceByReference;
import de.fhdw.wtf.generator.java.generatorModel.GenerationModelItem;
import de.fhdw.wtf.generator.java.generatorModel.Generic;
import de.fhdw.wtf.generator.java.visitor.GenerationModelItemVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public final class GenParameter
extends GenerationModelItem {
    private final GenTypeReference typ;
    private final Collection<GenParameterModifier> modifiers;
    private final ArrayList<Generic> generics;

    private GenParameter(String name, GenTypeReference typ) {
        super(name);
        this.typ = typ;
        this.modifiers = new Vector<GenParameterModifier>();
        this.generics = new ArrayList();
    }

    public static GenParameter create(String name, GenTypeReference typ) {
        return new GenParameter(name, typ);
    }

    public static GenParameter create(String name, GenImportType typ) {
        return GenParameter.create(name, GenTypeReferenceByReference.create(typ));
    }

    public static GenParameter create(String name, GenType typ) {
        return GenParameter.create(name, GenTypeReferenceByReference.create(typ));
    }

    public int hashCode() {
        return this.getGenerics().hashCode() ^ this.getModifiers().hashCode() ^ this.getName().hashCode() ^ this.getTyp().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GenParameter) {
            return ((GenParameter)obj).getName().equals(this.getName()) && ((GenParameter)obj).getTyp().equals(this.getTyp());
        }
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (!this.modifiers.isEmpty()) {
            for (GenParameterModifier genParameterModifier : this.modifiers) {
                result.append((Object)genParameterModifier);
                result.append(' ');
            }
        }
        result.append(this.typ.getFullyQualifiedName());
        if (!this.generics.isEmpty()) {
            result.append('<');
            for (GenType genType : this.generics) {
                result.append(genType.getName());
                result.append(',');
            }
            result.deleteCharAt(result.length() - 1);
            result.append('>');
        }
        result.append(' ');
        result.append(this.getName());
        return result.toString();
    }

    @Override
    public void accept(GenerationModelItemVisitor visitor) {
        visitor.handle(this);
    }

    public GenTypeReference getTyp() {
        return this.typ;
    }

    public Collection<GenParameterModifier> getModifiers() {
        return this.modifiers;
    }

    public ArrayList<Generic> getGenerics() {
        return this.generics;
    }
}

