package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenAspectAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaAttribute;

/**
 * This visitor handles all GenAttribute-types and returns values.
 * 
 * @param <X>
 *            The type of values returned by handle-methods.
 */
public interface GenAttributeVisitorReturn<X> {
	
	/**
	 * Handle method for objects of GenJavaAttribute-type.
	 * 
	 * @param attribute
	 *            GenJavaAttribute to handle.
	 * @return Value of type X
	 */
	X handleJavaAttribute(GenJavaAttribute attribute);
	
	/**
	 * Handle method for objects of GenAspectAttribute-type.
	 * 
	 * @param attribute
	 *            GenAspectAttribute to handle.
	 * @return Value of type X
	 */
	X handleAspectAttribute(GenAspectAttribute attribute);
	
}
