CREATE OR REPLACE PACKAGE BODY ClassFacade IS

PROCEDURE createUserType(id NUMBER, name VARCHAR2, abstract NUMBER, trans NUMBER)  IS
BEGIN
	INSERT INTO TYPE(id, name, abstract, trans) VALUES(id, name, abstract, trans);
END;
 
PROCEDURE INITIALIZE IS
BEGIN
	INSERT INTO TYPE(id, name, abstract, trans) VALUES(classfacade.string_id, 'String', 0, 0);
	INSERT INTO TYPE(id, name, abstract, trans) VALUES(classfacade.integer_id , 'Integer', 0, 0);
END;
    
PROCEDURE createUnidirAssociation(id NUMBER, name VARCHAR2, owner NUMBER, target NUMBER, essential NUMBER, uniq NUMBER) IS
BEGIN
	createAssociation(id,name,owner,target,essential,uniq);
END;
  
PROCEDURE createAssociation(id NUMBER, name VARCHAR2, owner NUMBER, target NUMBER, essential NUMBER, uniq NUMBER) IS
BEGIN
	INSERT INTO Association(id,name,owner,target,essential,uniq) VALUES(id,name,owner,target,essential,uniq);
END;
  
PROCEDURE createMapAssociation(id NUMBER, name VARCHAR2, owner NUMBER, target NUMBER, essential NUMBER, uniq NUMBER, map_key_type NUMBER) IS
BEGIN
	createUnidirAssociation(id,name, owner, target, essential, uniq);
    INSERT INTO MapAssociation(id, map_key_type) VALUES(id,map_key_type);
END;

PROCEDURE createSpecialization(ancestor NUMBER, descendant NUMBER) IS 
BEGIN
    INSERT INTO specialization(id, ancestor, descendant) VALUES(specialization_seq.nextval, ancestor, descendant);
END;
  
PROCEDURE finalizeSpecialization IS 
    CURSOR spec_cursor IS WITH partielle_ordnung_trans(ancestor,descendant) AS
		(SELECT ancestor,descendant FROM specialization
		UNION ALL
		SELECT child.ancestor,parent.descendant FROM specialization child, specialization parent
			WHERE parent.ancestor=child.descendant)
		SELECT ancestor,descendant FROM partielle_ordnung_trans
			WHERE (ancestor,descendant) NOT IN (SELECT ancestor,descendant FROM specialization)
		UNION 
		SELECT a.id AS ancestor, b.id AS descendant FROM type a, type b
			WHERE a.id=b.id AND (a.id,b.id) NOT IN
				(SELECT ancestor,descendant FROM specialization);
		spec_row spec_cursor%ROWTYPE;
		check_cycle NUMBER;
BEGIN
	OPEN spec_cursor;
	LOOP
		FETCH spec_cursor INTO spec_row;
			EXIT WHEN spec_cursor%NOTFOUND;
			SELECT count(*) INTO check_cycle FROM specialization s 
				WHERE s.descendant=spec_row.ancestor AND s.ancestor=spec_row.descendant;
			IF (spec_row.ancestor=spec_row.descendant) THEN
				IF (check_cycle=0) THEN
					INSERT INTO specialization(id, ancestor,descendant) VALUES(specialization_seq.nextval, spec_row.ancestor, spec_row.descendant);
				END IF;
			ELSE
				IF (check_cycle=0) THEN
					INSERT INTO specialization(id, ancestor,descendant) VALUES(specialization_seq.nextval, spec_row.ancestor, spec_row.descendant);
				ELSE 
					RAISE userexception.cycle_exception;
				END IF;
			END IF;
	END LOOP;
	CLOSE spec_cursor;
END;
 
PROCEDURE clearSpecialization IS
BEGIN
	DELETE FROM specialization;
END;
 
PROCEDURE clearAll IS 
BEGIN
	DELETE FROM Specialization;
	DELETE FROM MapAssociation;
	DELETE FROM Association;
	DELETE FROM type;
	DELETE FROM account_roles;
	DELETE FROM roles;
	DELETE FROM accounts;
END;
 
FUNCTION doesTypeExist(name VARCHAR2) RETURN NUMBER IS
	result NUMBER;
BEGIN
	SELECT id INTO result FROM type 
		WHERE type.name=name;
		IF (result=0) THEN
			RETURN result;
		ELSE
			RETURN 1;
		END IF;
END;
  
FUNCTION doesAssociationExist(name VARCHAR2) RETURN NUMBER IS
	result NUMBER;
BEGIN
	SELECT id INTO result FROM Association a 
		WHERE a.name=name;
		IF (result=0) THEN
			RETURN result;
		ELSE
			RETURN 1;
		END IF;
END;
  
FUNCTION getMaxIdFromType RETURN NUMBER IS
	result NUMBER;
BEGIN
	SELECT MAX(id) INTO result FROM type;
	RETURN result;
END;
 
FUNCTION getMaxIdFromAssociation RETURN NUMBER IS
	result NUMBER;
BEGIN
	SELECT MAX(id) INTO RESULT FROM Association;
	RETURN result;
END;
 
FUNCTION IsSuperclassTo(a NUMBER, d NUMBER) RETURN NUMBER IS
	result NUMBER;
BEGIN
	SELECT count(*) INTO RESULT FROM specialization s 
		WHERE s.ancestor=a AND s.descendant=d;
	RETURN result;
END;
  
FUNCTION getAllTypes RETURN classInfoCursor IS
	result classInfoCursor;
BEGIN
	OPEN result FOR
		SELECT id, name, abstract, trans FROM type;
    RETURN result;
END;
  
FUNCTION getAllUnidirAssociations RETURN UnidirAssociationInfoCursor IS
	result UnidirAssociationInfoCursor;
BEGIN
	OPEN result FOR
		SELECT a.id, a.name, a.owner, a.target, a.essential, a.uniq FROM Association a
			LEFT JOIN MapAssociation ma ON a.id=ma.id 
		WHERE ma.id IS NULL;
	RETURN result;
END;
  
FUNCTION getAllMapAssociations RETURN MapAssociationInfoCursor IS
	result MapAssociationInfoCursor;
BEGIN
	OPEN result FOR
		SELECT DISTINCT Association.id, Association.name, Association.owner, Association.target, MapAssociation.ID, Association.essential FROM MapAssociation
			INNER JOIN Association ON Association.id=MapAssociation.ID;
	RETURN result;
END;
  
FUNCTION getAllUnidirAssoWithFullName RETURN UnidirAssociationInfoCursor IS
	result UnidirAssociationInfoCursor;
BEGIN
	OPEN result FOR
		SELECT a.id, CONCAT(t.name,CONCAT('>',a.name)), a.owner, a.target, a.essential, a.uniq FROM Association a
			INNER JOIN type t on t.id=a.owner
			LEFT JOIN MapAssociation ma ON a.id=ma.id 
		WHERE ma.id IS NULL;
	RETURN result;
END;
  
FUNCTION getAllMapAssoWithFullName RETURN MapAssociationInfoCursor IS
	result MapAssociationInfoCursor;
BEGIN
	OPEN result FOR
	SELECT Association.id, CONCAT(t.name,CONCAT('>',Association.name)), Association.owner, Association.target, MapAssociation.ID, Association.essential  FROM MapAssociation
		INNER JOIN Association on Association.id=MapAssociation.ID
		INNER JOIN type t on t.id=Association.owner;
	RETURN result;
END;
    
PROCEDURE renameType(typeId NUMBER, newName VARCHAR2) IS 
BEGIN
	UPDATE Type SET name=newName
		WHERE id=typeId;
END;
 
PROCEDURE renameAssociation(assoId NUMBER, newName VARCHAR2) IS 
BEGIN
	UPDATE Association SET name=newName
		WHERE id=assoId;
END;
  
PROCEDURE pushDownLinks(oldAssociation NUMBER, newAssociations array_int) IS
BEGIN
	FOR i IN 1 .. newAssociations.COUNT
	LOOP
		UPDATE Link l SET l.instance_of=newAssociations (i)
    WHERE l.instance_of=oldAssociation AND
	ISSuperClassTo(
      (SELECT a.owner FROM Association a
		WHERE a.id=newAssociations (i)), 
		(SELECT o.instance_of FROM Object o 
			WHERE o.id=l.owner)
	) > 0;
	END LOOP;
END;
  
PROCEDURE deleteAssociation(oldAssociation NUMBER) IS
BEGIN
	DELETE FROM MapAssociation
		WHERE id=oldAssociation;
	DELETE FROM Association
		WHERE id=oldAssociation;
END;
 
PROCEDURE deleteUserTypeAndSpec(typeId NUMBER) IS
BEGIN
	DELETE FROM Specialization 
		WHERE ancestor=typeId OR descendant=typeId;
	DELETE FROM Type 
		WHERE id=typeId;
END;
 
 
end ClassFacade;

