package de.fhdw.wtf.persistence.utils;

import de.fhdw.wtf.persistence.meta.Matchable;

/**
 * Implementation of a generic Tuple of two Types X and Y.
 * 
 * @param <X>
 * @param <Y>
 */
public class Tuple<X, Y> {
	
	private final X first;
	
	private final Y second;
	
	/**
	 * 
	 * @return the first Component
	 */
	public X getFirst() {
		return this.first;
	}
	
	/**
	 * 
	 * @return the second Component
	 */
	public Y getSecond() {
		return this.second;
	}
	
	/**
	 * Constructor for a new tuple with first and, second.
	 * 
	 * @param first
	 * @param second
	 */
	public Tuple(final X first, final Y second) {
		super();
		this.first = first;
		this.second = second;
	}
	
	@SuppressWarnings("rawtypes")
	@Override
	public boolean equals(final java.lang.Object obj) {
		if (obj instanceof Tuple) {
			return this.customEquals((Tuple) obj);
		}
		return false;
	}
	
	private boolean customEquals(@SuppressWarnings("rawtypes") final Tuple obj) {
		return this.getFirst().equals(obj.getFirst()) && this.getSecond().equals(obj.getSecond());
	}
	
	@Override
	public String toString() {
		return "(" + this.getFirst() + "," + this.getSecond() + ")";
	}
	
	@Override
	public int hashCode() {
		return this.getFirst().hashCode() ^ this.getSecond().hashCode();
	}
	
}
