package de.fhdw.wtf.persistence.exception;

/**
 * A class to represent a persistence Exception wrapped into a Runtime exception to provide an ease of use when
 * interacting with the persistence layer at runtime.
 * 
 */
public class RuntimePersistenceException extends RuntimeException {
	/**
	 * the message of the exception.
	 */
	private static final String MESSAGE = "A Problem occured during accessing the database";
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * Constructor for a default RuntimePersistenceException.
	 */
	public RuntimePersistenceException() {
		super(MESSAGE);
	}
	
	/**
	 * Constructor for a RuntimePersistenceException, with possibility to append the causing Exception.
	 * 
	 * @param cause
	 *            A Throwable which caused this RuntimePersistenceException.
	 */
	public RuntimePersistenceException(final Throwable cause) {
		super(MESSAGE, cause);
	}
	
}
