package de.fhdw.wtf.persistence.exception;

import java.sql.SQLException;

/**
 * A Class to represent an Exception, which occurs when during finalization of the Specialization relationships of the
 * types a cycle is detected, because the specialization has to be a partial order.
 * 
 */
public class SpecializationCycleDetected extends PersistenceException {
	
	/**
	 * Error nummer of the Oracle UserException.
	 */
	public static final long ERRORCODE = 20000;
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * The Public constructor for a SpecializationCycleDetected Exception.
	 * 
	 * @param nested
	 *            The nested SQL Exception causing the error, usually an uncaught user defined PL/SQL-Exception.
	 */
	public SpecializationCycleDetected(final SQLException nested) {
		super("The Specialization hierarchy between the user types contains a cycle!!!", nested);
	}
	
}
