package de.fhdw.wtf.persistence.exception;

import java.sql.SQLException;

/**
 * A class to represent a supertype for all kinds of persistence Exceptions, which might occur during accessing the
 * Database.
 * 
 */
public abstract class PersistenceException extends Exception {
	
	/**
	 * The original SQL Exception, which causes the instantiation of this Persistence Exception.
	 */
	private final SQLException nestedException;
	
	/**
	 * Needed for serialization.
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * Protected supertype constructor for a new Persistence Exception.
	 * 
	 * @param message
	 *            A message describing the Error must be declared by each subtype
	 * @param nestedException
	 *            The original SQL Exception, causing the Error, to determine the origin of the Persistence Exception
	 */
	protected PersistenceException(final String message, final SQLException nestedException) {
		super(message);
		this.nestedException = nestedException;
	}
	
	@Override
	public void printStackTrace() {
		super.printStackTrace();
		if (this.nestedException != null) {
			this.nestedException.printStackTrace();
		}
	}
	
}
