/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.facade;

import de.fhdw.wtf.persistence.exception.ClassFacadeUninitializedException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.facade.ClassFacade;
import de.fhdw.wtf.persistence.facade.DatabaseManager;
import de.fhdw.wtf.persistence.facade.NoDatabaseClassFacadeImplementation;
import de.fhdw.wtf.persistence.facade.NoDatabaseObjectFacadeImplementation;
import de.fhdw.wtf.persistence.facade.ObjectFacade;
import java.io.IOException;

public final class NoDatabaseManager
extends DatabaseManager {
    private static NoDatabaseManager instance;
    private ClassFacade classFacade;
    private ObjectFacade objectFacade;
    private boolean connected = false;

    @Override
    public void setConnectionConstantsFromFile(String fileName) throws IOException {
    }

    @Override
    public void connect() throws PersistenceException {
        this.connected = true;
    }

    @Override
    public ClassFacade getClassFacade() {
        if (this.classFacade == null) {
            this.classFacade = new NoDatabaseClassFacadeImplementation();
        }
        return this.classFacade;
    }

    @Override
    public ObjectFacade getObjectFacade() throws ClassFacadeUninitializedException {
        if (!this.getClassFacade().hasBeenInitialized()) {
            throw new ClassFacadeUninitializedException();
        }
        if (this.objectFacade == null) {
            this.objectFacade = new NoDatabaseObjectFacadeImplementation(this.classFacade);
        }
        return this.objectFacade;
    }

    @Override
    public void disconnect() throws PersistenceException {
        this.connected = false;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void resetDatabase() throws PersistenceException, IOException {
        this.clearTables();
    }

    @Override
    public void clearTables() throws PersistenceException {
        this.getClassFacade().clear();
        this.getObjectFacade().clear();
    }

    public static synchronized NoDatabaseManager getInstance() {
        if (instance == null) {
            instance = new NoDatabaseManager();
        }
        return instance;
    }
}

