package de.fhdw.wtf.persistence.meta;

public class Role {
	
	private final long id;
	
	private final String name;
	
	public Role(final long id, final String name) {
		super();
		this.id = id;
		this.name = name;
	}
	
	public long getId() {
		return this.id;
	}
	
	public String getName() {
		return this.name;
	}
	
	@Override
	public boolean equals(final java.lang.Object obj) {
		if (obj instanceof Role) {
			final Role other = (Role) obj;
			return other.id == this.id && this.name.equals(other.name);
		}
		return false;
	}
	
	@Override
	public int hashCode() {
		return (int) this.id + this.name.hashCode();
	}
}
