package de.fhdw.wtf.persistence.meta;

/**
 * A class to represent an User Type. User Types are all types which are not base types.
 * 
 */
public class UserType extends Type {
	
	/**
	 * Constructor for a new User Type. It should only be called by the classfacade or a junit test case to guarantee
	 * consistency with the database.
	 * 
	 * @param id
	 *            The Id of the User Type.
	 * @param name
	 *            The name of the User Type.
	 * @param abs
	 *            A flag indicating whether the User type is abstract or not.
	 * @param trans
	 *            A Flag indicating whether instance to this user Types are also transactions.
	 */
	public UserType(final long id, final String name, final boolean abs, final boolean trans) {
		super(id, name, abs, trans);
	}
	
	@Override
	public void accept(final TypeVisitor typeVisitor) {
		typeVisitor.handleUserType(this);
		
	}
	
	@Override
	public <X> X accept(final TypeVisitorReturn<X> typeVisitor) {
		return typeVisitor.handleUserType(this);
	}
	
	@Override
	public <Exc extends Exception> void accept(final TypeVisitorException<Exc> typeVisitor) throws Exc {
		typeVisitor.handleUserType(this);
	}
	
	@Override
	public <X, Y extends Exception> X accept(final TypeVisitorReturnException<X, Y> typeVisitorReturnException)
			throws Y {
		return typeVisitorReturnException.handleUserType(this);
	}
	
	@Override
	public String toString() {
		return "(" + this.getId() + "," + this.getName() + "," + this.isAbs() + "," + this.isTrans() + ")";
	}
	
	@Override
	public boolean isTheSameAs(final java.lang.Object other) {
		if (other instanceof UserType) {
			final UserType type = (UserType) other;
			
			// Id is Unique for all UserTypes.
			return this.getId() == type.getId();
		}
		return false;
	}
	
}
