package de.fhdw.wtf.persistence.meta;

/**
 * A class to represent the Type Integer in the Metamodell. Theese are all integer numbers: ...-2, -1, 0, 1, 2,...
 * 
 */
public final class IntegerType extends Type {
	
	/**
	 * Static Identifier for type name.
	 */
	public static final String INTEGER_NAME = "Integer";
	
	/**
	 * The Id of Integer by Contract.
	 */
	public static final long Integer_ID = 2;
	
	/**
	 * The singleton Instance of Integer is stored in this field.
	 */
	private static IntegerType instance;
	
	/**
	 * This Method provides the only instance of the class Integer Type.
	 * 
	 * @return The Integer Type.
	 */
	public static synchronized IntegerType getInstance() {
		if (instance == null) {
			instance = new IntegerType(Integer_ID);
		}
		return instance;
	}
	
	/**
	 * Private constructor for a new Integer Type.
	 * 
	 * @param id
	 *            The Id of integer which is determined by the classfacade.
	 */
	private IntegerType(final long id) {
		super(id, INTEGER_NAME, false, false);
	}
	
	@Override
	public void accept(final TypeVisitor typeVisitor) {
		typeVisitor.handleBaseType(this);
		
	}
	
	@Override
	public <X> X accept(final TypeVisitorReturn<X> typeVisitor) {
		return typeVisitor.handleBaseType(this);
	}
	
	@Override
	public <Exc extends Exception> void accept(final TypeVisitorException<Exc> typeVisitor) throws Exc {
		typeVisitor.handleBaseType(this);
	}
	
	@Override
	public <X, Y extends Exception> X accept(final TypeVisitorReturnException<X, Y> typeVisitorReturnException)
			throws Y {
		return typeVisitorReturnException.handleBaseType(this);
	}
	
	@Override
	public boolean isTheSameAs(final java.lang.Object other) {
		return other instanceof IntegerType;
	}
	
}
