/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.meta;

import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.facade.ObjectFacade;
import de.fhdw.wtf.persistence.meta.IntegerType;
import de.fhdw.wtf.persistence.meta.Object;
import java.math.BigInteger;

public class IntegerValue
extends Object {
    private static ObjectFacade facade;
    private BigInteger value;
    private Long id;

    public static void setObjectFacade(ObjectFacade objectFacade) {
        facade = objectFacade;
    }

    public IntegerValue(long id) {
        super(IntegerType.getInstance());
        this.id = id;
    }

    public IntegerValue(BigInteger value) {
        super(IntegerType.getInstance());
        this.value = value;
    }

    public IntegerValue(Long id, BigInteger value) {
        super(IntegerType.getInstance());
        this.id = id;
        this.value = value;
    }

    public BigInteger getValue() {
        if (this.value == null) {
            try {
                this.value = facade.getIntForId(this.getId());
            }
            catch (PersistenceException e) {
                throw new Error(e);
            }
        }
        return this.value;
    }

    @Override
    public long getId() {
        if (this.id == null) {
            try {
                this.id = facade.getIdForInteger(this.getValue());
            }
            catch (PersistenceException e) {
                throw new Error(e);
            }
        }
        return this.id;
    }

    @Override
    public boolean isTheSameAs(java.lang.Object other) {
        if (!(other instanceof IntegerValue)) {
            return false;
        }
        return this.getId() == ((IntegerValue)other).getId();
    }
}

