package de.fhdw.wtf.persistence.utils;

import java.util.MissingResourceException;

/**
 * This class should read internal ".properties" files. At first, use the "getInstance(String propFile)" method to load
 * all key-value-pairs.
 *
 */
public interface PropertiesReader {
	
	/**
	 * Returns the value to the given key. If it does not exists, the result value will be "".
	 * 
	 * @param key
	 *            The Key
	 * @return The Value
	 */
	String getProperty(final String key);
	
	/**
	 * Loads all the key-value-pairs from the given file.
	 * 
	 * @param propFile
	 *            The internal path to the .properties-file.
	 * @throws MissingResourceException
	 *             Is thrown if the ressource file will not be found.
	 */
	void initialize(final String propFile) throws MissingResourceException;
	
}
