package de.fhdw.wtf.persistence.exception;

import java.io.File;
import java.io.IOException;

/**
 * This Exception is thrown when the given File cannot be deleted.
 * 
 */
public class FileDeleteIOException extends IOException {
	
	/**
	 * This Exception is thrown when the given File cannot be deleted.
	 * 
	 * @param file
	 *            the file
	 */
	public FileDeleteIOException(final File file) {
		super("The file " + file.getPath() + " cannot be deleted!");
	}
	
}
