package de.fhdw.wtf.persistence.meta;

/**
 * A class to represent an adhoc Transaction. An Adhoc Transaction is a Transaction, which is not typed and therefore
 * part of the Model. It can be used to manipulate the Database.
 * 
 */
public class AdhocTransaction implements Transaction {
	
	/**
	 * The Database Id of the Transaction. The Id is unique.
	 */
	private final long id;
	
	@Override
	public long getId() {
		return this.id;
	}
	
	/**
	 * Constructor for a new Adhoc Transaction. This constructor should not be called by any function different to
	 * provideAdhocTransaction in the Object Facade or any JUnit Test Case. Because it must be assured that the id also
	 * exists in the Database.
	 * 
	 * @param id
	 *            The id of the Adhoc Transaction. The Id is provided by the database.
	 */
	public AdhocTransaction(final long id) {
		super();
		this.id = id;
	}
	
	@Override
	public boolean equals(final java.lang.Object obj) {
		if (obj instanceof Transaction) {
			return this.customEquals((Transaction) obj);
		}
		return false;
	}
	
	/**
	 * Provides true, if two Transaction have the same Id.
	 * 
	 * @param obj
	 *            Any other Transaction, adhoc or not.
	 * @return Provides true if two Transactions are the same.
	 */
	private boolean customEquals(final Transaction obj) {
		return this.getId() == obj.getId();
	}
	
	@Override
	public int hashCode() {
		return super.hashCode();
	}
	
}
