package de.fhdw.wtf.persistence.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.SQLException;

import de.fhdw.wtf.persistence.exception.NotValidInputException;
import de.fhdw.wtf.persistence.meta.IntegerValue;
import de.fhdw.wtf.persistence.meta.Object;

/**
 * Wrapper for a Integer for a Database-Query.
 */
public class DBConnectionIntegerHandler implements DBConnectionObjectHandler {
	
	private final BigInteger integer;
	
	@Override
	public String getObjectTypeString() {
		return "Int";
	}
	
	@Override
	public void handleCall(final CallableStatement call, final int parameterIndex) throws SQLException {
		final BigDecimal wrapper = new BigDecimal(this.integer);
		call.setBigDecimal(parameterIndex, wrapper);
	}
	
	@Override
	public Object getObject() {
		return new IntegerValue(this.integer);
	}
	
	/**
	 * creates a wrapper for a integer for a database connection.
	 * 
	 * @param integer
	 *            the wrapped integer
	 * @throws NotValidInputException
	 *             throws when the given integer is null
	 */
	public DBConnectionIntegerHandler(final BigInteger integer) throws NotValidInputException {
		super();
		
		if (integer == null) {
			throw new NotValidInputException("integer");
		}
		
		this.integer = integer;
	}
}
