package de.fhdw.wtf.persistence.meta;

/**
 * A class to represent an object to a user Type.
 * 
 */
public class UserObject extends Object { // NOPMD: Object != java.lang.Object

	/**
	 * The identity of a user Object in the Database.
	 */
	private final long id;
	
	/**
	 * Constructor for a new User Object. It should only be called by the object facade or a junit test to guarantee
	 * consisteny with the database.
	 * 
	 * @param id
	 *            The Id of this object in the database.
	 * @param instanceOf
	 *            The Type of this User Object. It must be a user type.
	 * @return a UserTransaction when instance of is a transaction type UserObject otherwise.
	 */
	public static UserObject init(final long id, final Type instanceOf) {
		if (instanceOf.isTrans()) {
			return new UserTransaction(id, instanceOf);
		} else {
			return new UserObject(id, instanceOf);
		}
	}
	
	/**
	 * Constructor for a new User Object. It should only be called by the object facade or a junit test to guarantee
	 * consistency with the database.
	 * 
	 * @param id
	 *            The Id of this object in the database.
	 * @param instanceOf
	 *            The Type of this User Object. It must be a user type.
	 */
	protected UserObject(final long id, final Type instanceOf) {
		super(instanceOf);
		this.id = id;
	}
	
	@Override
	public long getId() {
		return this.id;
	}
	
	@Override
	public boolean isTheSameAs(final java.lang.Object other) {
		if (!(other instanceof UserObject)) {
			return false;
		}
		
		final UserObject uo = (UserObject) other;
		
		return this.getId() == uo.getId();
	}
	
}
