/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.utils;

import de.fhdw.wtf.persistence.exception.NotValidInputException;
import de.fhdw.wtf.persistence.meta.IntegerValue;
import de.fhdw.wtf.persistence.utils.DBConnectionObjectHandler;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.SQLException;

public class DBConnectionIntegerHandler
implements DBConnectionObjectHandler {
    private final BigInteger integer;

    @Override
    public String getObjectTypeString() {
        return "Int";
    }

    @Override
    public void handleCall(CallableStatement call, int parameterIndex) throws SQLException {
        BigDecimal wrapper = new BigDecimal(this.integer);
        call.setBigDecimal(parameterIndex, wrapper);
    }

    @Override
    public de.fhdw.wtf.persistence.meta.Object getObject() {
        return new IntegerValue(this.integer);
    }

    public DBConnectionIntegerHandler(BigInteger integer) throws NotValidInputException {
        if (integer == null) {
            throw new NotValidInputException("integer");
        }
        this.integer = integer;
    }
}

