/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.facade;

import de.fhdw.wtf.persistence.exception.ClassFacadeUninitializedException;
import de.fhdw.wtf.persistence.exception.NotConnectableException;
import de.fhdw.wtf.persistence.exception.NotConnectedException;
import de.fhdw.wtf.persistence.exception.OracleJDBCDriverMissing;
import de.fhdw.wtf.persistence.exception.OtherSQLException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.facade.ClassFacade;
import de.fhdw.wtf.persistence.facade.DatabaseManager;
import de.fhdw.wtf.persistence.facade.ObjectFacade;
import de.fhdw.wtf.persistence.facade.OracleClassFacadeImplementation;
import de.fhdw.wtf.persistence.facade.OracleDataBasePreparator;
import de.fhdw.wtf.persistence.facade.OracleObjectFacadeImplementation;
import de.fhdw.wtf.persistence.utils.PropertiesReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public final class OracleDatabaseManager
extends DatabaseManager {
    private static final String JDBC_SEPERATOR = ":";
    private static final String CONNECTION_PREFIX_ORACLE = "jdbc:oracle:thin:@";
    private static final String JDBC_ORACLE_DRIVER_NAME = "oracle.jdbc.OracleDriver";
    private ClassFacade classFacade;
    private static OracleDatabaseManager instance;
    private boolean isConnected = false;
    private String schemaName;
    private String userName;
    private String userPassword;
    private String oracleSID;
    private String hostname;
    private String port;
    private Connection defaultConnection;

    private OracleDatabaseManager() {
    }

    @Override
    public void setConnectionConstantsFromFile(PropertiesReader reader) throws IOException {
        this.schemaName = reader.getProperty("schema");
        this.userName = reader.getProperty("username");
        this.userPassword = reader.getProperty("password");
        this.oracleSID = reader.getProperty("sid");
        this.hostname = reader.getProperty("hostname");
        this.port = reader.getProperty("port");
    }

    @Override
    public void connect() throws PersistenceException {
        try {
            Class.forName(JDBC_ORACLE_DRIVER_NAME);
            this.isConnected = true;
            this.defaultConnection = DriverManager.getConnection(CONNECTION_PREFIX_ORACLE + this.getHostname() + JDBC_SEPERATOR + this.getPort() + JDBC_SEPERATOR + this.getOracleSID(), this.getUserName(), this.getUserPassword());
        }
        catch (ClassNotFoundException e) {
            throw new OracleJDBCDriverMissing();
        }
        catch (SQLException e) {
            throw new NotConnectableException(this, e);
        }
    }

    public Connection getConnection() throws PersistenceException {
        if (this.isConnected) {
            return this.defaultConnection;
        }
        throw new NotConnectedException();
    }

    @Override
    public ClassFacade getClassFacade() {
        if (this.classFacade == null) {
            this.classFacade = new OracleClassFacadeImplementation(this);
        }
        return this.classFacade;
    }

    @Override
    public ObjectFacade getObjectFacade() throws ClassFacadeUninitializedException {
        return new OracleObjectFacadeImplementation(this, this.getClassFacade().getTypeManager());
    }

    @Override
    public void resetDatabase() throws PersistenceException, IOException {
        OracleDataBasePreparator prep = new OracleDataBasePreparator();
        boolean tableStructureValid = prep.isTableStructureValid();
        if (tableStructureValid) {
            this.clearTables();
        } else {
            prep.dropWholeSchema();
            prep.createWholeSchema();
        }
        boolean areProceduresCreated = prep.areProceduresCreated();
        if (!areProceduresCreated) {
            prep.createProcedures();
        }
    }

    @Override
    public void clearTables() throws PersistenceException {
        new OracleObjectFacadeImplementation(this, null).clear();
        this.getClassFacade().clear();
    }

    public static synchronized OracleDatabaseManager getInstance() {
        if (instance == null) {
            instance = new OracleDatabaseManager();
        }
        return instance;
    }

    @Override
    public void disconnect() throws PersistenceException {
        try {
            this.getConnection().close();
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        this.isConnected = false;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public String getOracleSID() {
        return this.oracleSID;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPort() {
        return this.port;
    }
}

