package de.fhdw.wtf.persistence.meta;

/**
 * point to point association with a owner and a target.
 */
public class UnidirectionalAssociation extends Association {
	
	/**
	 * Creates an unidirectional association between two types.
	 * 
	 * @param id
	 *            the id of the association
	 * @param name
	 *            the name of the association
	 * @param owner
	 *            the owner of the association
	 * @param target
	 *            the target of the association
	 * @param essential
	 *            true when the link to the target in a uml is a 1.. and false when 0..
	 * @param unique
	 *            true when the link to the target in a uml is a ..1 and false when ..*
	 */
	public UnidirectionalAssociation(final long id,
			final String name,
			final UserType owner,
			final Type target,
			final boolean essential,
			final boolean unique) {
		super(id, name, owner, target, essential, unique);
	}
	
	@Override
	public boolean isTheSameAs(final java.lang.Object other) {
		if (other instanceof UnidirectionalAssociation) {
			return super.isTheSameAs(other);
		}
		return false;
	}
	
}
