/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.meta;

import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.facade.ObjectFacade;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.StringType;

public class StringValue
extends Object {
    private static ObjectFacade facade;
    private String value;
    private Long id;

    public static void setObjectFacade(ObjectFacade objectFacade) {
        facade = objectFacade;
    }

    public StringValue(long id) {
        super(StringType.getInstance());
        this.id = id;
    }

    public StringValue(String value) {
        super(StringType.getInstance());
        this.value = value;
    }

    public StringValue(Long id, String value) {
        super(StringType.getInstance());
        this.id = id;
        this.value = value;
    }

    public String getValue() {
        if (this.value == null) {
            try {
                this.value = facade.getStringForId(this.getId());
            }
            catch (PersistenceException e) {
                throw new Error(e);
            }
        }
        return this.value;
    }

    @Override
    public long getId() {
        if (this.id == null) {
            try {
                this.id = facade.getIdForString(this.getValue());
            }
            catch (PersistenceException e) {
                throw new Error(e);
            }
        }
        return this.id;
    }

    @Override
    public boolean isTheSameAs(java.lang.Object other) {
        if (!(other instanceof StringValue)) {
            return false;
        }
        return this.getId() == ((StringValue)other).getId();
    }
}

