package de.fhdw.wtf.persistence.meta;

/**
 * A class to represent an object in the database. An object is identified by its type, which can be a user type or a
 * base type and an Id which is unique.
 * 
 */
public abstract class Object extends InstanceItem {
	
	/**
	 * The Type of this Object. Could be a Base Type or an User Object.
	 */
	private final Type instanceOf;
	
	/**
	 * Protected superclass constructor which must be inherited by its subclasses.
	 * 
	 * @param instanceOf
	 *            The Type of this Object.
	 */
	protected Object(final Type instanceOf) {
		this.instanceOf = instanceOf;
	}
	
	/**
	 * Getter for the Type.
	 * 
	 * @return Provides the Type of this Object.
	 */
	public Type getInstanceOf() {
		return this.instanceOf;
	}
	
	/**
	 * A static factory Method for objects. It checks whether the the given Tuple of Object Id and type information is a
	 * base type or not and creates a new object instance of this object.
	 * 
	 * @param id
	 *            The Id of the object in the database.
	 * @param instance_of
	 *            The type information of the Object.
	 * @return Provides a new Instance of the given object. If its a BaseType a BaseTypeValue Class will be instantiated
	 *         otherwise a new user object will be instantiated.
	 */
	public static Object checkForBaseTypes(final long id, final Type instance_of) {
		if (instance_of.getId() == StringType.getInstance().getId()) {
			return new StringValue(id);
		} else if (instance_of.getId() == IntegerType.getInstance().getId()) {
			return new IntegerValue(id);
		} else {
			return UserObject.init(id, instance_of);
		}
	}
	
	@Override
	public String toString() {
		return "(" + this.getId() + "," + this.getInstanceOf().toString() + ")";
	}
	
}
