package de.fhdw.wtf.persistence.exception;

/**
 * Fehler der geworfen wird, wenn eine Assoziation oder ein Type nicht in der Datenbank gefunden wurde.
 */
public class TypeOrAssociationNotFoundException extends PersistenceException {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * a part of the message of the exception.
	 */
	private static final String NOT_FOUND_MESAGE_PREFIX = "For the given name ";
	/**
	 * a part of the message of the exception.
	 */
	private static final String NOT_FOUND_MESSAGE_SUFFIX = " no association or type was found";
	
	/**
	 * @param id
	 *            ist die id des nicht gefundenen Types oder der Assoziation in der Datenbank.
	 */
	public TypeOrAssociationNotFoundException(final long id) {
		super(NOT_FOUND_MESAGE_PREFIX + id + NOT_FOUND_MESSAGE_SUFFIX, null);
	}
	
	/**
	 * @param name
	 *            ist der name des nicht gefundenen Types oder der Assoziation in der Datenbank.
	 */
	public TypeOrAssociationNotFoundException(final String name) {
		super(NOT_FOUND_MESAGE_PREFIX + name + NOT_FOUND_MESSAGE_SUFFIX, null);
		
	}
	
	@Override
	public void printStackTrace() {
		System.err.println(this.getMessage() + this.fillInStackTrace());
	}
	
}
