package de.fhdw.wtf.persistence.meta;

/**
 * A class to represent an abstract Model Item, which can be a Type or an UnidirectionalAssociation.
 */
public abstract class ModelItem implements Matchable {
	
	/**
	 * The id of the the Model Item in the Database.
	 */
	private final long id;
	
	/**
	 * The name of the Model Item.
	 */
	private final String name;
	
	/**
	 * Getter for Id.
	 * 
	 * @return Provides the unique identifier of this model item.
	 */
	public long getId() {
		return this.id;
	}
	
	/**
	 * Getter for name.
	 * 
	 * @return Provides the name of this Model Item.
	 */
	public String getName() {
		return this.name;
	}
	
	/**
	 * Constructor for a new ModelItem.
	 * 
	 * @param id
	 *            the identifier in the database
	 * @param name
	 *            the name of the Identifier
	 */
	protected ModelItem(final long id, final String name) {
		super();
		this.id = id;
		this.name = name;
	}
	
}
