/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.facade;

import de.fhdw.wtf.persistence.exception.ClassFacadeUninitializedException;
import de.fhdw.wtf.persistence.exception.DuplicateUserTypeException;
import de.fhdw.wtf.persistence.exception.NotDeletableException;
import de.fhdw.wtf.persistence.exception.NotValidOperationException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.exception.SpecializationCycleDetected;
import de.fhdw.wtf.persistence.exception.TypeOrAssociationNotFoundException;
import de.fhdw.wtf.persistence.facade.ClassFacade;
import de.fhdw.wtf.persistence.facade.TypeManager;
import de.fhdw.wtf.persistence.facade.TypeManagerImplementation;
import de.fhdw.wtf.persistence.meta.Association;
import de.fhdw.wtf.persistence.meta.IntegerType;
import de.fhdw.wtf.persistence.meta.MapAssociation;
import de.fhdw.wtf.persistence.meta.Specialization;
import de.fhdw.wtf.persistence.meta.StringType;
import de.fhdw.wtf.persistence.meta.Type;
import de.fhdw.wtf.persistence.meta.TypeVisitorException;
import de.fhdw.wtf.persistence.meta.UnidirectionalAssociation;
import de.fhdw.wtf.persistence.meta.UserType;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public class NoDatabaseClassFacadeImplementation
implements ClassFacade {
    private static final long INITIAL_NEXT_ID = 3L;
    private static final String RENAMING_BASE_TYPE_MESSAGE = "Renaming a BaseType is not supported!";
    private final TypeManagerImplementation typeManager = TypeManagerImplementation.getInstance();
    private long nextId;

    public NoDatabaseClassFacadeImplementation() {
        this.initializeBaseTypes();
        this.nextId = 3L;
    }

    @Override
    public UserType createUserType(String name, boolean abs, boolean transaction) throws DuplicateUserTypeException {
        try {
            this.typeManager.getTypeforName(name);
            throw new DuplicateUserTypeException(name);
        }
        catch (TypeOrAssociationNotFoundException e) {
            UserType userType = new UserType(this.getAndIncrementNextId(), name, abs, transaction);
            this.typeManager.saveType(userType);
            this.typeManager.saveSpecialization(new Specialization(userType, userType));
            return userType;
        }
    }

    @Override
    public UnidirectionalAssociation createUnidirectionalAssociation(String name, boolean essential, boolean unique, UserType owner, Type target) throws PersistenceException {
        UnidirectionalAssociation association = new UnidirectionalAssociation(this.getAndIncrementNextId(), name, owner, target, essential, unique);
        this.typeManager.saveAssociation(association);
        return association;
    }

    @Override
    public MapAssociation createMapAssociation(String name, boolean essential, UserType owner, Type target, Type keyType) throws PersistenceException {
        MapAssociation association = new MapAssociation(this.getAndIncrementNextId(), name, owner, target, keyType, essential);
        this.typeManager.saveAssociation(association);
        return association;
    }

    @Override
    public void createSpecializationBetween(UserType ancestor, Type descendant) throws PersistenceException {
        Collection<Specialization> allSpecializations = this.typeManager.getAllSpecializations();
        if (allSpecializations.contains(new Specialization(descendant, ancestor))) {
            throw new SpecializationCycleDetected(new SQLException());
        }
        for (Specialization current : allSpecializations) {
            boolean notReflexive;
            boolean bl = notReflexive = !current.getAncestor().isTheSameAs(current.getDescendant());
            if (notReflexive && ancestor.isTheSameAs(current.getDescendant())) {
                this.typeManager.saveSpecialization(new Specialization(current.getAncestor(), descendant));
                continue;
            }
            if (!notReflexive || !descendant.isTheSameAs(current.getAncestor())) continue;
            this.typeManager.saveSpecialization(new Specialization(ancestor, current.getDescendant()));
        }
        this.typeManager.saveSpecialization(new Specialization(ancestor, descendant));
    }

    @Override
    public boolean isSuperClassTo(Type ancestor, Type descendant) throws PersistenceException {
        for (Specialization current : this.typeManager.getAllSpecializations()) {
            if (current.getAncestor().getId() != ancestor.getId() || current.getDescendant().getId() != descendant.getId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void finalizeSpecialization() throws PersistenceException {
    }

    @Override
    public void clear() throws PersistenceException {
        this.typeManager.clear();
        this.initializeBaseTypes();
        this.nextId = 3L;
    }

    @Override
    public void renameType(final Long typeId, final String newName) throws PersistenceException {
        Type type = this.getTypeManager().getTypeForId(typeId);
        type.accept(new TypeVisitorException<PersistenceException>(){

            @Override
            public void handleUserType(UserType argument) throws PersistenceException {
                NoDatabaseClassFacadeImplementation.this.deleteUserType(typeId);
                NoDatabaseClassFacadeImplementation.this.typeManager.saveType(new UserType(argument.getId(), newName, argument.isAbs(), argument.isTrans()));
            }

            @Override
            public void handleBaseType(Type t) throws NotValidOperationException {
                throw new NotValidOperationException(NoDatabaseClassFacadeImplementation.RENAMING_BASE_TYPE_MESSAGE);
            }
        });
    }

    @Override
    public void renameAssociation(Long assoId, String newName) throws PersistenceException {
        try {
            UnidirectionalAssociation association = this.typeManager.getUnidirectionalAssociationForId(assoId);
            this.deleteAssociation(assoId);
            this.typeManager.saveAssociation(new UnidirectionalAssociation(association.getId(), newName, association.getOwner(), association.getTarget(), association.isEssential(), association.isUnique()));
        }
        catch (TypeOrAssociationNotFoundException exception) {
            MapAssociation association = this.typeManager.getMapAssociationForId(assoId);
            this.deleteAssociation(assoId);
            this.typeManager.saveAssociation(new MapAssociation(association.getId(), newName, association.getOwner(), association.getTarget(), association.getKeyType(), association.isEssential()));
        }
    }

    @Override
    public void deleteAssociation(Long associationId) throws PersistenceException {
        this.typeManager.deleteAssociation(associationId);
    }

    @Override
    public void deleteUserType(final Long typeId) throws PersistenceException {
        Type type = this.getTypeManager().getTypeForId(typeId);
        type.accept(new TypeVisitorException<NotDeletableException>(){

            @Override
            public void handleUserType(UserType argument) throws NotDeletableException {
                try {
                    NoDatabaseClassFacadeImplementation.this.typeManager.deleteType(typeId);
                    for (Specialization current : NoDatabaseClassFacadeImplementation.this.typeManager.getAllSpecializations()) {
                        if (!current.getAncestor().isTheSameAs(argument) && !current.getDescendant().isTheSameAs(argument)) continue;
                        NoDatabaseClassFacadeImplementation.this.typeManager.deleteSpecialization(current);
                    }
                }
                catch (TypeOrAssociationNotFoundException e) {
                    throw new Error();
                }
            }

            @Override
            public void handleBaseType(Type t) throws NotDeletableException {
                throw new NotDeletableException();
            }
        });
    }

    @Override
    public void updateLinksToNewAssociation(Long associationId, Collection<Long> newAssociationIds) throws PersistenceException {
    }

    @Override
    public void moveLinksAndCreateObjects(List<Long> oldAssoIds, Association newAsso, UserType newType, List<Long> newAssoIds) throws PersistenceException {
    }

    private void initializeBaseTypes() {
        this.typeManager.saveType(StringType.getInstance());
        this.typeManager.saveSpecialization(new Specialization(StringType.getInstance(), StringType.getInstance()));
        this.typeManager.saveType(IntegerType.getInstance());
        this.typeManager.saveSpecialization(new Specialization(IntegerType.getInstance(), IntegerType.getInstance()));
    }

    @Override
    public void initialize() throws PersistenceException {
    }

    @Override
    public void initializeForRuntime() throws PersistenceException {
    }

    @Override
    public boolean hasBeenInitialized() {
        return true;
    }

    @Override
    public TypeManager getTypeManager() throws ClassFacadeUninitializedException {
        return this.typeManager;
    }

    private long getAndIncrementNextId() {
        long result = this.nextId++;
        return result;
    }
}

