/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.contest;

import de.fhdw.gaming.contest.RecordingObserver;
import de.fhdw.gaming.contest.ui.InteractiveStreamInputProvider;
import de.fhdw.gaming.contest.util.CombinatoricsHelper;
import de.fhdw.gaming.contest.util.ComparablePair;
import de.fhdw.gaming.core.domain.DefaultGameBuilderFactoryProvider;
import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.domain.util.GameBuilderFactoryWrapper;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.core.ui.util.ChainedInputProvider;
import de.fhdw.gaming.core.ui.util.NonInteractiveInputProvider;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public final class Main {
    private static final String PARAM_GAME = "game";
    private static final String PARAM_REPEAT_COUNT = "repeatCount";
    private static final String PARAM_PLAY_AGAINST_SELF = "playAgainstSelf";
    private static final String PARAM_PERMUTATE_STRATEGIES = "permutateStrategies";
    private final File recordingDirectory;

    public Main(String recordingDirectory) {
        this.recordingDirectory = recordingDirectory != null ? new File(recordingDirectory) : null;
    }

    public void run() throws InputProviderException, GameException, InterruptedException, IOException {
        CompetitionParameters competitionParameters = this.determineCompetitionParameters();
        CompetitionResults competitionResults = this.runCompetition(competitionParameters);
        System.out.println();
        int numberOfGamesPlayed = competitionResults.getTotalNumberOfGamesPlayed();
        System.out.printf("A total of %d games played. Results:%n", numberOfGamesPlayed);
        this.printResult(numberOfGamesPlayed, competitionResults.getGameResults());
    }

    private void printResult(int numberOfGamesPlayed, Map<Class<?>, StrategyData> gameResults) {
        TreeMap<ComparablePair, List> ranking = new TreeMap<ComparablePair, List>();
        Comparator reverseCompare = ((Comparator)Integer::compareTo).reversed();
        int maxNameLength = 0;
        int maxOutcomeLength = 0;
        for (StrategyData strategyData : gameResults.values()) {
            String name = strategyData.getName();
            ComparablePair<Integer, Integer> key = ComparablePair.of(strategyData.getCounters().getOrDefault(PlayerState.WON, 0), reverseCompare, strategyData.getCounters().getOrDefault(PlayerState.DRAW, 0), reverseCompare);
            ranking.computeIfAbsent(key, k -> new ArrayList()).add(strategyData);
            maxNameLength = Math.max(maxNameLength, name.length());
            maxOutcomeLength = Math.max(maxOutcomeLength, String.format("%.3f", strategyData.getTotalOutcome()).length());
        }
        int maxNumFieldWidth = String.valueOf(numberOfGamesPlayed).length();
        int place = 1;
        for (Map.Entry rankingEntry : ranking.entrySet()) {
            List strategyDataList = (List)rankingEntry.getValue();
            boolean first = true;
            for (StrategyData strategyData : strategyDataList) {
                System.out.printf(String.format("  %%s Strategy %%-%1$ds [WON: %%%2$dd, DRAW: %%%2$dd, LOST: %%%2$dd, RESIGNED: %%%2$dd] [OUTCOME: %%%3$d.3f]%n", maxNameLength, maxNumFieldWidth, maxOutcomeLength), String.format(first ? "%4d. place:" : "            ", place), strategyData.getName(), ((ComparablePair)rankingEntry.getKey()).getFirst(), ((ComparablePair)rankingEntry.getKey()).getSecond(), strategyData.getCounters().getOrDefault(PlayerState.LOST, 0), strategyData.getCounters().getOrDefault(PlayerState.RESIGNED, 0), strategyData.getTotalOutcome());
                first = false;
            }
            place += strategyDataList.size();
        }
    }

    private CompetitionParameters determineCompetitionParameters() throws InputProviderException {
        LinkedHashSet<GameBuilderFactoryWrapper> gameBuilderFactories = new LinkedHashSet<GameBuilderFactoryWrapper>();
        for (GameBuilderFactory gameBuilderFactory : new DefaultGameBuilderFactoryProvider().getGameBuilderFactories()) {
            gameBuilderFactories.add(new GameBuilderFactoryWrapper(gameBuilderFactory));
        }
        InputProvider inputProvider = new InteractiveStreamInputProvider(System.in, (OutputStream)System.out).needObject(PARAM_GAME, "Which game to play", Optional.empty(), gameBuilderFactories).needInteger(PARAM_REPEAT_COUNT, "Number of games per contest", (Optional)Optional.of(100), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(1000))}).needInteger("maxComputationTimePerMove", "Maximum computation time in seconds per player and move", (Optional)Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1))}).needBoolean(PARAM_PLAY_AGAINST_SELF, "Do strategies play against themselves?", (Optional)Optional.of(false), new Validator[0]).needBoolean(PARAM_PERMUTATE_STRATEGIES, "Are strategies permutated?", (Optional)Optional.of(true), new Validator[0]);
        if (gameBuilderFactories.size() == 1) {
            inputProvider.fixedObject(PARAM_GAME, gameBuilderFactories.iterator().next());
        }
        Map data = inputProvider.requestData("Competition parameters");
        GameBuilderFactory gameBuilderFactory = (GameBuilderFactory)data.get(PARAM_GAME);
        int repeatCount = (Integer)data.get(PARAM_REPEAT_COUNT);
        int maxComputationTimePerMove = (Integer)data.get("maxComputationTimePerMove");
        boolean playAgainstSelf = (Boolean)data.get(PARAM_PLAY_AGAINST_SELF);
        boolean permutateStrategies = (Boolean)data.get(PARAM_PERMUTATE_STRATEGIES);
        return new CompetitionParameters(gameBuilderFactory, repeatCount, maxComputationTimePerMove, playAgainstSelf, permutateStrategies);
    }

    private CompetitionResults runCompetition(CompetitionParameters competitionParameters) throws InputProviderException, GameException, InterruptedException, IOException {
        CompetitionResults competitionResults = new CompetitionResults();
        GameBuilderFactory gameBuilderFactory = competitionParameters.getGameBuilderFactory();
        ArrayList<Strategy> strategies = new ArrayList<Strategy>(gameBuilderFactory.getStrategies());
        strategies.removeIf(Strategy::isInteractive);
        Comparator<Strategy> comp = Comparator.comparingInt(strategies::indexOf);
        int contestNumber = 1;
        for (int numPlayers = gameBuilderFactory.getMinimumNumberOfPlayers(); numPlayers <= gameBuilderFactory.getMaximumNumberOfPlayers(); ++numPlayers) {
            List strategySets = competitionParameters.isPlayAgainstSelf() ? (competitionParameters.isPermutateStrategies() ? CombinatoricsHelper.combinationsWithRepetition(strategies, numPlayers).flatMap(strategyList -> CombinatoricsHelper.permutationsWithRepetition(strategyList, comp)).collect(Collectors.toList()) : CombinatoricsHelper.combinationsWithRepetition(strategies, numPlayers).collect(Collectors.toList())) : (competitionParameters.isPermutateStrategies() ? CombinatoricsHelper.combinations(strategies, numPlayers).flatMap(CombinatoricsHelper::permutations).collect(Collectors.toList()) : CombinatoricsHelper.combinations(strategies, numPlayers).collect(Collectors.toList()));
            for (List strategySet : strategySets) {
                System.out.printf("Contest %d. Number of players: %d. Strategies involved: %s%n", contestNumber, numPlayers, strategySet);
                ContestParameters contestParameters = this.determineContestParameters(competitionParameters, strategySet);
                this.runContest(contestNumber, contestParameters, competitionResults);
                ++contestNumber;
            }
        }
        return competitionResults;
    }

    private ContestParameters determineContestParameters(CompetitionParameters competitionParameters, List<? extends Strategy<?, ?, ?>> strategies) throws InputProviderException, GameException {
        ListIterator<Strategy<?, ?, ?>> itStrategy = strategies.listIterator(strategies.size());
        NonInteractiveInputProvider mostRecentProvider = null;
        int nextPlayerId = strategies.size();
        while (itStrategy.hasPrevious()) {
            NonInteractiveInputProvider lastPlayerProvider = mostRecentProvider;
            NonInteractiveInputProvider playerInputProvider = lastPlayerProvider == null ? new NonInteractiveInputProvider() : new ChainedInputProvider((InputProvider)new NonInteractiveInputProvider(), lastDataSet -> lastPlayerProvider);
            playerInputProvider.fixedString("playerName", Integer.toString(nextPlayerId--));
            playerInputProvider.fixedObject("playerStrategy", itStrategy.previous());
            mostRecentProvider = playerInputProvider;
        }
        NonInteractiveInputProvider firstPlayerProvider = mostRecentProvider;
        NonInteractiveInputProvider gameInputProvider = firstPlayerProvider == null ? new NonInteractiveInputProvider() : new ChainedInputProvider((InputProvider)new NonInteractiveInputProvider(), lastDataSet -> firstPlayerProvider);
        gameInputProvider.fixedInteger("maxComputationTimePerMove", Integer.valueOf(competitionParameters.getMaxComputationTimePerMove()));
        GameBuilder gameBuilder = competitionParameters.getGameBuilderFactory().createGameBuilder((InputProvider)gameInputProvider);
        return new ContestParameters(gameBuilder, competitionParameters.getNumberOfGamesPerContest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runContest(int contestNumber, ContestParameters contestParameters, CompetitionResults competitionResults) throws GameException, InterruptedException, IOException {
        File contestDirectory = this.recordingDirectory != null ? new File(this.recordingDirectory, String.format("%d", contestNumber)) : null;
        GameBuilder gameBuilder = contestParameters.getGameBuilder();
        for (int i = 1; i <= contestParameters.getNumberOfGames(); ++i) {
            try (RecordingObserver observer = null;
                 Game game = gameBuilder.build(i);){
                if (contestDirectory != null) {
                    File gameEventFile = Main.createGameEventFile(contestDirectory, String.format("%d.log", i));
                    observer = new RecordingObserver(gameEventFile);
                    game.addObserver((Observer)observer);
                }
                this.runGame(game, competitionResults);
                continue;
            }
        }
        System.out.println();
    }

    private void runGame(Game<?, ?, ?, ?> game, CompetitionResults competitionResults) throws InterruptedException {
        Map<Class<?>, StrategyData> gameResults = competitionResults.getGameResults();
        game.start();
        while (!game.isFinished()) {
            game.makeMove();
        }
        competitionResults.incrementTotalNumberOfGamesPlayed();
        System.out.print('.');
        Map strategies = game.getStrategies();
        for (Player player : game.getPlayers().values()) {
            Strategy strategy = (Strategy)strategies.get(player.getName());
            Class<?> strategyClass = strategy.getClass();
            StrategyData strategyData = gameResults.computeIfAbsent(strategyClass, k -> new StrategyData(strategy.toString(), new EnumMap<PlayerState, Integer>(PlayerState.class)));
            strategyData.getCounters().compute(player.getState(), (key, value) -> value == null ? 1 : value + 1);
            strategyData.addOutcome((Double)player.getOutcome().orElseThrow());
        }
    }

    private static File createGameEventFile(File parentDirectory, String fileName) throws IOException {
        if (parentDirectory == null) {
            return null;
        }
        if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
            throw new IOException(String.format("Could not create directory for recording events: %s", parentDirectory.getCanonicalPath()));
        }
        if (!parentDirectory.isDirectory()) {
            throw new IOException(String.format("Directory for recording events is not a directory: %s", parentDirectory.getCanonicalPath()));
        }
        return new File(parentDirectory, fileName);
    }

    public static void main(String[] parameters) {
        Options options = new Options();
        options.addOption("r", "recordDir", true, "Specifies the directory where to record events");
        try {
            CommandLine commandLine = new DefaultParser().parse(options, parameters);
            new Main(commandLine.getOptionValue('r')).run();
        }
        catch (Exception e) {
            System.err.print("Game contest aborted due to exception: ");
            e.printStackTrace(System.err);
            System.exit(3);
        }
    }

    private static final class CompetitionParameters {
        private final GameBuilderFactory gameBuilderFactory;
        private final int numberOfGamesPerContest;
        private final int maxComputationTimePerMove;
        private final boolean playAgainstSelf;
        private final boolean permutateStrategies;

        CompetitionParameters(GameBuilderFactory gameBuilderFactory, int numberOfGamesPerContest, int maxComputationTimePerMove, boolean playAgainstSelf, boolean permutateStrategies) {
            this.gameBuilderFactory = gameBuilderFactory;
            this.numberOfGamesPerContest = numberOfGamesPerContest;
            this.maxComputationTimePerMove = maxComputationTimePerMove;
            this.playAgainstSelf = playAgainstSelf;
            this.permutateStrategies = permutateStrategies;
        }

        GameBuilderFactory getGameBuilderFactory() {
            return this.gameBuilderFactory;
        }

        int getNumberOfGamesPerContest() {
            return this.numberOfGamesPerContest;
        }

        public int getMaxComputationTimePerMove() {
            return this.maxComputationTimePerMove;
        }

        public boolean isPlayAgainstSelf() {
            return this.playAgainstSelf;
        }

        public boolean isPermutateStrategies() {
            return this.permutateStrategies;
        }
    }

    private static final class CompetitionResults {
        private final Map<Class<?>, StrategyData> gameResults = new LinkedHashMap();
        private int totalNumberOfGamesPlayed;

        CompetitionResults() {
        }

        Map<Class<?>, StrategyData> getGameResults() {
            return this.gameResults;
        }

        int getTotalNumberOfGamesPlayed() {
            return this.totalNumberOfGamesPlayed;
        }

        void incrementTotalNumberOfGamesPlayed() {
            ++this.totalNumberOfGamesPlayed;
        }
    }

    private static final class StrategyData {
        private final String name;
        private final EnumMap<PlayerState, Integer> countersPerState;
        private double totalOutcome;

        StrategyData(String name, EnumMap<PlayerState, Integer> countersPerState) {
            this.name = name;
            this.countersPerState = countersPerState;
            this.totalOutcome = 0.0;
        }

        String getName() {
            return this.name;
        }

        EnumMap<PlayerState, Integer> getCounters() {
            return this.countersPerState;
        }

        double getTotalOutcome() {
            return this.totalOutcome;
        }

        void addOutcome(double outcomeToAdd) {
            this.totalOutcome += outcomeToAdd;
        }
    }

    private static final class ContestParameters {
        private final GameBuilder gameBuilder;
        private final int numberOfGames;

        ContestParameters(GameBuilder gameBuilder, int numberOfGames) {
            this.gameBuilder = gameBuilder;
            this.numberOfGames = numberOfGames;
        }

        GameBuilder getGameBuilder() {
            return this.gameBuilder;
        }

        int getNumberOfGames() {
            return this.numberOfGames;
        }
    }
}

