/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.contest.util;

import de.fhdw.gaming.contest.util.CombinatoricsHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;

final class CombinationSplitIterator<T>
implements Spliterator<List<T>> {
    private final List<T> input;
    private final int[] combination;
    private final int sublistSize;
    private final boolean withRepetition;
    private final long totalNumberOfCombinations;

    CombinationSplitIterator(List<T> input, int sublistSize, boolean withRepetition) {
        this.input = input;
        this.sublistSize = sublistSize;
        this.withRepetition = withRepetition;
        this.combination = new int[sublistSize];
        for (int i = 0; i < sublistSize; ++i) {
            this.combination[i] = withRepetition ? 0 : i;
        }
        this.totalNumberOfCombinations = withRepetition ? CombinatoricsHelper.nOverK(this.input.size() + this.sublistSize - 1, this.sublistSize) : CombinatoricsHelper.nOverK(this.input.size(), this.sublistSize);
    }

    @Override
    public boolean tryAdvance(Consumer<? super List<T>> action) {
        if (this.combination[this.sublistSize - 1] >= this.input.size()) {
            return false;
        }
        action.accept(this.toList());
        this.computeNextCombination();
        return true;
    }

    @Override
    public Spliterator<List<T>> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.totalNumberOfCombinations;
    }

    @Override
    public int characteristics() {
        return 337;
    }

    private List<T> toList() {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < this.sublistSize; ++i) {
            result.add(this.input.get(this.combination[i]));
        }
        return result;
    }

    private void computeNextCombination() {
        int index;
        for (index = this.sublistSize - 1; index != 0 && this.combination[index] == this.input.size() - this.sublistSize + (this.withRepetition ? this.sublistSize - 1 : index); --index) {
        }
        int n = index;
        this.combination[n] = this.combination[n] + 1;
        for (int i = index + 1; i < this.sublistSize; ++i) {
            this.combination[i] = this.combination[i - 1] + (this.withRepetition ? 0 : 1);
        }
    }
}

