/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.contest.util;

import java.util.Comparator;
import java.util.Objects;

public final class ComparablePair<T, U>
implements Comparable<ComparablePair<T, U>> {
    private final T first;
    private final Comparator<T> compFirst;
    private final U second;
    private final Comparator<U> compSecond;

    private ComparablePair(T first, Comparator<T> compFirst, U second, Comparator<U> compSecond) {
        this.first = first;
        this.second = second;
        this.compFirst = compFirst;
        this.compSecond = compSecond;
    }

    public static <T extends Comparable<T>, U extends Comparable<U>> ComparablePair<T, U> of(T first, U second) {
        return new ComparablePair<T, U>(first, Comparable::compareTo, second, Comparable::compareTo);
    }

    public static <T extends Comparable<T>, U> ComparablePair<T, U> of(T first, U second, Comparator<U> compSecond) {
        return new ComparablePair<T, U>(first, Comparable::compareTo, second, compSecond);
    }

    public static <T, U extends Comparable<U>> ComparablePair<T, U> of(T first, Comparator<T> compFirst, U second) {
        return new ComparablePair<T, U>(first, compFirst, second, Comparable::compareTo);
    }

    public static <T, U> ComparablePair<T, U> of(T first, Comparator<T> compFirst, U second, Comparator<U> compSecond) {
        return new ComparablePair<T, U>(first, compFirst, second, compSecond);
    }

    public T getFirst() {
        return this.first;
    }

    public U getSecond() {
        return this.second;
    }

    @Override
    public int compareTo(ComparablePair<T, U> other) {
        int compareFirst = this.compFirst.compare(this.first, other.first);
        return compareFirst != 0 ? compareFirst : this.compSecond.compare(this.second, other.second);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComparablePair) {
            ComparablePair other = (ComparablePair)obj;
            return this.first.equals(other.first) && this.second.equals(other.second);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public String toString() {
        return String.format("(%s, %s)", this.first, this.second);
    }
}

