/*
 * Copyright © 2020 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of gaming-gui.
 *
 * Gaming-gui is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Gaming-gui is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * gaming-gui. If not, see <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.gui;

import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.core.domain.ObserverFactory;

/**
 * Implements {@link ObserverFactory} by returning a {@link LogObserver} object.
 */
public final class LogObserverFactory implements ObserverFactory {

    @Override
    public Observer createObserver() {
        return LogObserver.INSTANCE;
    }
}
