/*
 * Copyright © 2020-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of gaming-gui.
 *
 * Gaming-gui is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Gaming-gui is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * gaming-gui. If not, see <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.gui;

import java.util.Optional;

import de.fhdw.gaming.core.domain.Game;
import javafx.scene.Node;

/**
 * Observes GUI events.
 */
public interface GuiObserver {

    /**
     * Indicates that a new game has been created.
     *
     * @param game The game.
     * @return A {@link Node} that is to be attached.
     */
    Optional<Node> gameCreated(Game<?, ?, ?, ?> game);

    /**
     * Indicates that a game has been paused.
     *
     * @param game The game.
     */
    void gamePaused(Game<?, ?, ?, ?> game);

    /**
     * Indicates that a game has been resumed.
     *
     * @param game The game.
     */
    void gameResumed(Game<?, ?, ?, ?> game);

    /**
     * Indicates that an existing game is about to be destroyed.
     *
     * @param game The game.
     */
    void gameDestroyed(Game<?, ?, ?, ?> game);
}
