/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.gui;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import java.util.Optional;
import java.util.Set;
import javafx.application.Platform;
import javafx.scene.control.ListView;

final class LogObserver
implements Observer {
    public static final LogObserver INSTANCE = new LogObserver();
    private Optional<ListView<String>> label = Optional.empty();

    private LogObserver() {
    }

    public void setLog(ListView<String> log) {
        this.label = Optional.ofNullable(log);
    }

    public void started(Game<?, ?, ?, ?> game, State<?, ?> state) {
        Platform.runLater(() -> this.label.ifPresent(l -> l.getItems().add((Object)"Game started.")));
    }

    public void nextPlayersComputed(Game<?, ?, ?, ?> game, State<?, ?> state, Set<? extends Player<?>> players) {
        Platform.runLater(() -> this.label.ifPresent(l -> l.getItems().add((Object)String.format("Next player(s): %s.", players))));
    }

    public void illegalPlayerRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player) {
        Platform.runLater(() -> this.label.ifPresent(l -> l.getItems().add((Object)String.format("Illegal player rejected: %s.", player))));
    }

    public void legalMoveApplied(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player, Move<?, ?> move) {
        Platform.runLater(() -> this.label.ifPresent(l -> l.getItems().add((Object)String.format("Move applied for player %s: %s.", player, move))));
    }

    public void illegalMoveRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player, Optional<Move<?, ?>> move, String reason) {
        Platform.runLater(() -> this.label.ifPresent(l -> l.getItems().add((Object)String.format("Move rejected for player %s: %s. Reason: %s.", player, move, reason))));
    }

    public void overdueMoveRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player, Optional<Move<?, ?>> chosenMove) {
        Platform.runLater(() -> this.label.ifPresent(l -> l.getItems().add((Object)String.format("Overdue move rejected for player %s. Chosen move: %s.", player, chosenMove))));
    }

    public void playerResigned(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player) {
        Platform.runLater(() -> this.label.ifPresent(l -> l.getItems().add((Object)String.format("Player<?> %s has resigned.", player))));
    }

    public void playerOvertaken(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> overtakenPlayer, Player<?> overtakingPlayer) {
        Platform.runLater(() -> this.label.ifPresent(l -> l.getItems().add((Object)String.format("Player %s has been overtaken by player %s.", overtakenPlayer, overtakingPlayer))));
    }

    public void finished(Game<?, ?, ?, ?> game, State<?, ?> state) {
        String gameResult = LogObserver.getGameResult(game);
        Platform.runLater(() -> this.label.ifPresent(l -> l.getItems().add((Object)String.format("Game finished.%s", gameResult.isEmpty() ? "" : String.format(" Result:%s", gameResult)))));
    }

    private static String getGameResult(Game<?, ?, ?, ?> game) {
        StringBuilder sb = new StringBuilder();
        for (Player player : game.getPlayers().values()) {
            sb.append(" Player ").append(player).append('.');
        }
        return sb.toString();
    }
}

