/*
 * Decompiled with CFR 0.152.
 */
package ablaeufe.operation;

import ablaeufe.meta.AtomarerProzesstyp;
import ablaeufe.meta.Porttyp;
import ablaeufe.operation.KonsistenzVerletztException;
import ablaeufe.operation.Port;
import ablaeufe.operation.Prozess;
import java.util.Optional;

public abstract class AtomarerProzess
extends Prozess {
    protected AtomarerProzess() {
    }

    @Override
    public abstract AtomarerProzesstyp getTyp();

    public void connectTo(AtomarerProzess prozess) {
        Port verbindungsport = this.erstelleVerbindungsport(prozess);
        this.addOutport(verbindungsport);
        prozess.addInport(verbindungsport);
    }

    private Port erstelleVerbindungsport(AtomarerProzess prozess) {
        Optional<Porttyp> verbindungsporttyp = this.getTyp().getOutporttypen().stream().filter(porttyp -> this.outporttypIstInporttypDesAnderenProzesses(prozess, (Porttyp)porttyp)).filter(porttyp -> !this.outporttypIstBereitsTypisiert(prozess, (Porttyp)porttyp)).findFirst();
        if (verbindungsporttyp.isPresent()) {
            return Port.create(verbindungsporttyp.get());
        }
        throw new KonsistenzVerletztException("Die beiden Prozesse k\u00f6nnen nicht miteinander verbunden werden!Auf der Metaebene existiert kein Porttyp, welcher gleichzeitig Outporttyp des einen Prozesses und Inporttyp des anderen Prozesse ist. Oder alle gemeinsamen Porttypen sind bereits durch Ports typisiert und somit belegt!");
    }

    private boolean outporttypIstInporttypDesAnderenProzesses(AtomarerProzess prozess, Porttyp porttyp) {
        return prozess.getTyp().getInporttypen().contains(porttyp);
    }

    private boolean outporttypIstBereitsTypisiert(AtomarerProzess prozess, Porttyp outporttyp) {
        boolean alsOutportTypisiert = this.getOutports().stream().anyMatch(port -> port.getTyp().equals(outporttyp));
        boolean alsInportBeimAnderenProzessTypisiert = prozess.getInports().stream().anyMatch(port -> port.getTyp().equals(outporttyp));
        return alsOutportTypisiert && alsInportBeimAnderenProzessTypisiert;
    }
}

