/*
 * Decompiled with CFR 0.152.
 */
package auftraege;

import auftraege.Dokumentenklasse;
import auftraege.ServiceLevelAgreement;
import auftraege.Variable;
import auftraege.VoraussichtlicheDokumentenklassenVariableVisitor;
import auftraege.auftragsBildungsParameter.BeilagenArten;
import auftraege.auftragsBildungsParameter.BlattAnzahlSpanne;
import auftraege.auftragsBildungsParameter.SendungsAnzahlSpanne;
import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariable;
import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariablenVisitor;
import auftraege.auftragsBildungsParameter.abstraction.VoraussichtlicheDokumentenklassenVariable;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.BlattAnzahl;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.Id;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.Kommentar;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.ProzessModell;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.SendungsAnzahl;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.UnbekannteVariable;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.UnbekannteVariablen;
import auftraege.versand.Kunde;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import maschine.faehigkeit.DruckTyp;
import maschine.faehigkeit.Drucken;
import maschine.faehigkeit.FaehigkeitVisitor;
import maschine.faehigkeit.FarbDruckTyp;
import maschine.faehigkeit.Kuvertieren;
import maschine.faehigkeit.SimplesDrucken;
import maschine.faehigkeit.SimplesKuvertieren;
import material.auspraegungen.Papierformat;
import material.kuvert.KuvertFormat;
import util.ClassObjectMap;
import util.Fraction;
import util.exceptions.SollteNichtPassierenException;
import zeit.eintraege.Zeitraum;
import zeit.serientermin.IntervallSerienTermin;
import zeit.serientermin.SerienTermin;

public final class VoraussichtlicheDokumentenklasse {
    private final ClassObjectMap<VoraussichtlicheDokumentenklassenVariable> variablen;
    private static final VoraussichtlicheDokumentenklassenVariableVisitor<DokumentenklassenVariable> VORAUSSICHTLICHE_ZU_ECHTE_VARIABLEN_WORST_CASE_VISITOR = new VoraussichtlicheDokumentenklassenVariableVisitor<DokumentenklassenVariable>(){

        @Override
        public DokumentenklassenVariable handle(BlattAnzahlSpanne blattAnzahlSpanne) {
            return BlattAnzahl.create(((BlattAnzahl)blattAnzahlSpanne.getObereGrenze()).intValue() - 1);
        }

        @Override
        public DokumentenklassenVariable handle(SendungsAnzahlSpanne sendungsAnzahlSpanne) {
            return SendungsAnzahl.create(((SendungsAnzahl)sendungsAnzahlSpanne.getObereGrenze()).intValue() - 1);
        }

        @Override
        public DokumentenklassenVariable handle(DokumentenklassenVariable dokumentenklassenVariable) {
            return dokumentenklassenVariable;
        }

        @Override
        public DokumentenklassenVariable handle(SerienTermin serienTermin) {
            return null;
        }
    };

    private static DokumentenklassenVariablenVisitor<DokumentenklassenVariable> tatsaechlicheZuEchteVariablenAverageCaseVisitor(final int anzahlSchichten) {
        return new DokumentenklassenVariablenVisitor<DokumentenklassenVariable>(){

            @Override
            public DokumentenklassenVariable handle(KuvertFormat kuvertFormat) {
                return kuvertFormat;
            }

            @Override
            public DokumentenklassenVariable handle(ProzessModell prozessModell) {
                return prozessModell;
            }

            @Override
            public DokumentenklassenVariable handle(DruckTyp druckTyp) {
                return druckTyp;
            }

            @Override
            public DokumentenklassenVariable handle(FarbDruckTyp farbDruckTyp) {
                return farbDruckTyp;
            }

            @Override
            public DokumentenklassenVariable handle(ServiceLevelAgreement serviceLevelAgreement) {
                return serviceLevelAgreement;
            }

            @Override
            public DokumentenklassenVariable handle(Papierformat papierformat) {
                return papierformat;
            }

            @Override
            public DokumentenklassenVariable handle(BlattAnzahl blattAnzahl) {
                return BlattAnzahl.create(blattAnzahl.intValue() / anzahlSchichten);
            }

            @Override
            public DokumentenklassenVariable handle(Id id) {
                return id;
            }

            @Override
            public DokumentenklassenVariable handle(SendungsAnzahl sendungsAnzahl) {
                return SendungsAnzahl.create(sendungsAnzahl.intValue() / anzahlSchichten);
            }

            @Override
            public DokumentenklassenVariable handle(Kunde kunde) {
                return kunde;
            }

            @Override
            public DokumentenklassenVariable handle(BeilagenArten beilagenarten) {
                return beilagenarten;
            }

            @Override
            public DokumentenklassenVariable handle(UnbekannteVariable unbekannteVariable) {
                return unbekannteVariable;
            }

            @Override
            public DokumentenklassenVariable handle(UnbekannteVariablen unbekannteVariablen) {
                return unbekannteVariablen;
            }

            @Override
            public DokumentenklassenVariable handle(Kommentar kommentar) {
                return kommentar;
            }
        };
    }

    private VoraussichtlicheDokumentenklassenVariableVisitor<DokumentenklassenVariable> voraussichtlicheZuEchteVariablenAverageCaseVisistor(final int anzahlSchichten) {
        return new VoraussichtlicheDokumentenklassenVariableVisitor<DokumentenklassenVariable>(){

            @Override
            public DokumentenklassenVariable handle(BlattAnzahlSpanne blattAnzahlSpanne) {
                Fraction obere = Fraction.valueOf(((BlattAnzahl)blattAnzahlSpanne.getObereGrenze()).getValue());
                Fraction untere = Fraction.valueOf(((BlattAnzahl)blattAnzahlSpanne.getUntereGrenze()).getValue());
                return BlattAnzahl.create(obere.add(untere).divide(Fraction.valueOf(2 * anzahlSchichten)).intValue());
            }

            @Override
            public DokumentenklassenVariable handle(SendungsAnzahlSpanne sendungsAnzahlSpanne) {
                Fraction obere = Fraction.valueOf(((SendungsAnzahl)sendungsAnzahlSpanne.getObereGrenze()).getValue());
                Fraction untere = Fraction.valueOf(((SendungsAnzahl)sendungsAnzahlSpanne.getUntereGrenze()).getValue());
                return SendungsAnzahl.create(obere.add(untere).divide(Fraction.valueOf(2 * anzahlSchichten)).intValue());
            }

            @Override
            public DokumentenklassenVariable handle(DokumentenklassenVariable dokumentenklassenVariable) {
                return (DokumentenklassenVariable)dokumentenklassenVariable.accept(VoraussichtlicheDokumentenklasse.tatsaechlicheZuEchteVariablenAverageCaseVisitor(anzahlSchichten));
            }

            @Override
            public DokumentenklassenVariable handle(SerienTermin serienTermin) {
                return null;
            }
        };
    }

    private VoraussichtlicheDokumentenklasse(ClassObjectMap<VoraussichtlicheDokumentenklassenVariable> variablen) {
        this.variablen = variablen;
    }

    public static VoraussichtlicheDokumentenklasse create(Collection<Variable> variablen) {
        ClassObjectMap<VoraussichtlicheDokumentenklassenVariable> com = new ClassObjectMap<VoraussichtlicheDokumentenklassenVariable>();
        variablen.stream().map(VoraussichtlicheDokumentenklassenVariable::create).forEach(com::put);
        if (com.getBySuperclass(SerienTermin.class).isEmpty()) {
            throw new IllegalArgumentException("eine Voraussichtliche Dokumentenklasse sollte immer einen Termin angegeben haben!");
        }
        return new VoraussichtlicheDokumentenklasse(com);
    }

    public static VoraussichtlicheDokumentenklasse create(Variable ... variablen) {
        return VoraussichtlicheDokumentenklasse.create(Arrays.asList(variablen));
    }

    public Optional<Dokumentenklasse> toDokumentenklasseWorstCase(LocalDateTime eingangszeitpunkt) {
        this.fuelleAllesAufWasFehlt();
        Iterator<SerienTermin> serienTermin = this.variablen.getBySuperclass(SerienTermin.class).iterator();
        if (!serienTermin.hasNext()) {
            throw new SollteNichtPassierenException("eine Voraussichtliche Dokumentenklasse sollte immer einen Termin angegeben haben!");
        }
        if (!serienTermin.next().beinhaltetZeitpunkt(eingangszeitpunkt)) {
            return Optional.empty();
        }
        return Optional.of(Dokumentenklasse.create(eingangszeitpunkt, (DokumentenklassenVariable[])this.variablen.valueStream().map(voraussichtlicheVariable -> voraussichtlicheVariable.accept(VORAUSSICHTLICHE_ZU_ECHTE_VARIABLEN_WORST_CASE_VISITOR)).filter(Objects::nonNull).toArray(DokumentenklassenVariable[]::new)));
    }

    private void fuelleAllesAufWasFehlt() {
        ProzessModell prozessModell = this.variablen.putIfNotExists(ProzessModell.DRUCKEN_KUVERTIEREN);
        this.variablen.putIfNotExists(Papierformat.A4);
        prozessModell.getFaehigkeiten().forEach(maschinenFaehigkeit -> maschinenFaehigkeit.accept(new FaehigkeitVisitor<Void>(){

            @Override
            public Void handle(Drucken drucken) {
                throw new SollteNichtPassierenException("hier kann nur ein [SimplesDrucken] ankommen.");
            }

            @Override
            public Void handle(Kuvertieren kuvertieren) {
                throw new SollteNichtPassierenException("hier kann nur ein [SimplesKuvertieren] ankommen.");
            }

            @Override
            public Void handle(SimplesDrucken simplesDrucken) {
                VoraussichtlicheDokumentenklasse.this.fuelleAufFuerDruck();
                return null;
            }

            @Override
            public Void handle(SimplesKuvertieren simplesKuvertieren) {
                VoraussichtlicheDokumentenklasse.this.fuelleAufFuerKuvertierung();
                return null;
            }
        }));
    }

    private void fuelleAufFuerDruck() {
        this.variablen.putIfNotExists(FarbDruckTyp.Farbdruck);
        this.variablen.putIfNotExists(DruckTyp.duplex);
    }

    private void fuelleAufFuerKuvertierung() {
        this.variablen.putIfNotExists(KuvertFormat.C5);
    }

    public Optional<Dokumentenklasse> toDokumentenklasseAverageCase(LocalDateTime eingangszeitpunkt, int anzahlSchichten) {
        this.fuelleAllesAufWasFehlt();
        Iterator<SerienTermin> serienTermin = this.variablen.getBySuperclass(SerienTermin.class).iterator();
        if (!serienTermin.hasNext()) {
            throw new SollteNichtPassierenException("eine Voraussichtliche Dokumentenklasse sollte immer einen Termin angegeben haben!");
        }
        if (!serienTermin.next().beinhaltetZeitpunkt(eingangszeitpunkt)) {
            return Optional.empty();
        }
        return Optional.of(Dokumentenklasse.create(eingangszeitpunkt, (DokumentenklassenVariable[])this.variablen.valueStream().map(v -> v.accept(this.voraussichtlicheZuEchteVariablenAverageCaseVisistor(anzahlSchichten))).filter(Objects::nonNull).toArray(DokumentenklassenVariable[]::new)));
    }

    public Zeitraum getZeitraum() {
        return this.variablen.get(IntervallSerienTermin.class).orElseThrow(SollteNichtPassierenException::new).getEintrag().getZeitraum();
    }
}

