/*
 * Decompiled with CFR 0.152.
 */
package zeit.eintraege;

import com.google.common.base.Objects;
import java.time.LocalDateTime;
import javax.measure.quantity.Time;
import tec.uom.se.ComparableQuantity;
import zeit.eintraege.KalenderEintragTyp;
import zeit.eintraege.KalenderEintragVisitor;
import zeit.eintraege.Zeitraum;

public abstract class KalenderEintrag {
    private final Zeitraum zeitraum;
    private final KalenderEintragTyp typ;

    protected KalenderEintrag(LocalDateTime von, ComparableQuantity<Time> dauer, KalenderEintragTyp typ) {
        this.zeitraum = Zeitraum.create(von, dauer);
        this.typ = typ;
    }

    protected KalenderEintrag(LocalDateTime von, LocalDateTime bis, KalenderEintragTyp typ) {
        this.zeitraum = Zeitraum.create(von, bis);
        this.typ = typ;
    }

    public boolean contains(KalenderEintrag eintrag) {
        return this.zeitraum.contains(eintrag.zeitraum.getVon()) && this.zeitraum.contains(eintrag.zeitraum.getBis());
    }

    public boolean isVerfuegbar() {
        return this.typ.isVerfuegbar();
    }

    public boolean isNichtVerfuegbar() {
        return !this.isVerfuegbar();
    }

    public KalenderEintragTyp getTyp() {
        return this.typ;
    }

    public Zeitraum getZeitraum() {
        return this.zeitraum;
    }

    public LocalDateTime getVon() {
        return this.zeitraum.getVon();
    }

    public LocalDateTime getBis() {
        return this.getZeitraum().getBis();
    }

    public ComparableQuantity<Time> getDauer() {
        return this.getZeitraum().getDauer();
    }

    public boolean contains(LocalDateTime zeitpunkt) {
        return this.getZeitraum().contains(zeitpunkt);
    }

    public abstract <T> T accept(KalenderEintragVisitor<T> var1);

    public String toString() {
        return "KalenderEintrag{zeitraum=" + this.zeitraum + ", typ=" + (Object)((Object)this.typ) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KalenderEintrag)) {
            return false;
        }
        KalenderEintrag that = (KalenderEintrag)o;
        return Objects.equal((Object)this.zeitraum, (Object)that.zeitraum) && this.typ == that.typ;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zeitraum, this.typ});
    }
}

