/*
 * Decompiled with CFR 0.152.
 */
package auftraege;

import auftraege.Dokumentenklasse;
import auftraege.ServiceLevelAgreement;
import auftraege.auftragsBildungsParameter.BeilagenArten;
import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariable;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.ProzessModell;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import maschine.Maschine;
import maschine.faehigkeit.DruckTyp;
import maschine.faehigkeit.Drucken;
import maschine.faehigkeit.FaehigkeitVisitor;
import maschine.faehigkeit.FarbDruckTyp;
import maschine.faehigkeit.Kuvertieren;
import maschine.faehigkeit.MaschinenFaehigkeit;
import maschine.faehigkeit.SimplesDrucken;
import maschine.faehigkeit.SimplesKuvertieren;
import material.MaterialMitMessung;
import material.kuvert.KuvertFormat;
import mensch.Mitarbeiter;
import util.ClassObjectMap;
import util.Pair;
import zeit.eintraege.MaschinenBelegungEintrag;
import zeit.eintraege.MenschBelegungEintrag;

public class ProduktionsAuftrag {
    private final List<Dokumentenklasse> dokumentenklassen;
    private final Map<Maschine, MaschinenBelegungEintrag> maschinenBelegungen;
    private final Map<Pair<Mitarbeiter, MaschinenFaehigkeit>, MenschBelegungEintrag> menschBelegungen;

    public ProduktionsAuftrag(List<Dokumentenklasse> klassen) {
        this.dokumentenklassen = klassen;
        this.maschinenBelegungen = new HashMap<Maschine, MaschinenBelegungEintrag>();
        this.menschBelegungen = new HashMap<Pair<Mitarbeiter, MaschinenFaehigkeit>, MenschBelegungEintrag>();
    }

    public List<Dokumentenklasse> getDokumentenklassen() {
        return this.dokumentenklassen;
    }

    public int getAnzahlBlaetter() {
        return this.dokumentenklassen.stream().mapToInt(Dokumentenklasse::getAnzahlBlaetter).sum();
    }

    public int getAnzahlSendungen() {
        return this.dokumentenklassen.stream().mapToInt(Dokumentenklasse::getAnzahlSendungen).sum();
    }

    public ServiceLevelAgreement getSla() {
        return this.dokumentenklassen.stream().min(Comparator.comparing(dokumentenklasse -> dokumentenklasse.getSla().getFrist((Dokumentenklasse)dokumentenklasse))).map(Dokumentenklasse::getSla).orElse(ServiceLevelAgreement.MAX_VALUE);
    }

    public DruckTyp getDruckTyp() {
        return this.dokumentenklassen.stream().map(dokumentenklasse -> dokumentenklasse.getVariable(DruckTyp.class)).flatMap(evtlDruckTyp -> evtlDruckTyp.map(Stream::of).orElseGet(Stream::empty)).max(Comparator.comparing(Enum::ordinal)).orElse(DruckTyp.duplex);
    }

    public FarbDruckTyp getFarbDruckTyp() {
        return this.dokumentenklassen.stream().map(dokumentenklasse -> dokumentenklasse.getVariable(FarbDruckTyp.class)).flatMap(evtlFarbDruckTyp -> evtlFarbDruckTyp.map(Stream::of).orElseGet(Stream::empty)).max(Comparator.comparing(Enum::ordinal)).orElse(FarbDruckTyp.Farbdruck);
    }

    public List<MaterialMitMessung<?>> getBenoetigteMaterialien() {
        return Collections.emptyList();
    }

    public ProzessModell getProzessModell() {
        Set<MaschinenFaehigkeit> faehigkeiten = this.dokumentenklassen.stream().map(Dokumentenklasse::getProzessModell).map(ProzessModell::getFaehigkeiten).flatMap(Collection::stream).collect(Collectors.toSet());
        return new ProzessModell(faehigkeiten);
    }

    public String toString() {
        return "ProduktionsAuftrag{" + this.dokumentenklassen + "}";
    }

    public Map<MaschinenFaehigkeit, ClassObjectMap<DokumentenklassenVariable>> getMaschinenRelevanteFaehigkeiten() {
        ProzessModell prozessmodell = this.dokumentenklassen.stream().map(Dokumentenklasse::getProzessModell).findFirst().orElseThrow(() -> new NoSuchElementException("Die Dokumentenklassen m\u00fcssen ein ProzessModell haben!"));
        final ClassObjectMap classObjectMap4Drucken = new ClassObjectMap();
        final ClassObjectMap classObjectMap4Kuvertieren = new ClassObjectMap();
        final HashMap<MaschinenFaehigkeit, ClassObjectMap<DokumentenklassenVariable>> ret = new HashMap<MaschinenFaehigkeit, ClassObjectMap<DokumentenklassenVariable>>();
        prozessmodell.getFaehigkeiten().forEach(e -> e.accept(new FaehigkeitVisitor<Void>(){

            @Override
            public Void handle(Drucken drucken) {
                return null;
            }

            @Override
            public Void handle(Kuvertieren kuvertieren) {
                return null;
            }

            @Override
            public Void handle(SimplesDrucken simplesDrucken) {
                DruckTyp druckTyp = (DruckTyp)ProduktionsAuftrag.this.dokumentenklassen.stream().map(dk -> dk.getVariable(DruckTyp.class)).flatMap(e -> e.map(Stream::of).orElseGet(Stream::empty)).max(Comparator.naturalOrder()).orElseThrow(() -> new NoSuchElementException("Die Dokumentenklassen m\u00fcssen einen Drucktypen haben!"));
                FarbDruckTyp farbDruckTyp = (FarbDruckTyp)ProduktionsAuftrag.this.dokumentenklassen.stream().map(dk -> dk.getVariable(FarbDruckTyp.class)).flatMap(e -> e.map(Stream::of).orElseGet(Stream::empty)).max(Comparator.naturalOrder()).orElseThrow(() -> new NoSuchElementException("Die Dokumentenklassen m\u00fcssen einen FarbDrucktypen haben!"));
                classObjectMap4Drucken.putAll(druckTyp, farbDruckTyp, new ProzessModell(simplesDrucken));
                ret.put(simplesDrucken, classObjectMap4Drucken);
                return null;
            }

            @Override
            public Void handle(SimplesKuvertieren simplesKuvertieren) {
                KuvertFormat kuvertFormat = (KuvertFormat)ProduktionsAuftrag.this.dokumentenklassen.stream().map(dk -> dk.getVariable(KuvertFormat.class)).flatMap(e -> e.map(Stream::of).orElseGet(Stream::empty)).max(Comparator.naturalOrder()).orElseThrow(() -> new NoSuchElementException("Die Dokumentenklassen m\u00fcssen einen Kuvertformat haben!"));
                classObjectMap4Kuvertieren.putAll(kuvertFormat, new ProzessModell(simplesKuvertieren));
                ret.put(simplesKuvertieren, classObjectMap4Kuvertieren);
                return null;
            }
        }));
        return ret;
    }

    public LocalDateTime getFruehstenEingangszeitpunkt() {
        return this.dokumentenklassen.stream().map(Dokumentenklasse::getEingangsZeitpunkt).min(LocalDateTime::compareTo).orElseThrow(() -> new RuntimeException("es kann keinen Produktionsauftrag ohne Dokumentenklassen geben!"));
    }

    public Map<Maschine, MaschinenBelegungEintrag> getMaschinenBelegungen() {
        return this.maschinenBelegungen;
    }

    public Map<Pair<Mitarbeiter, MaschinenFaehigkeit>, MenschBelegungEintrag> getMenschBelegungen() {
        return this.menschBelegungen;
    }

    public void addMenschBelegungsEintrag(Mitarbeiter mitarbeiter, MaschinenFaehigkeit maschinenFaehigkeit, MenschBelegungEintrag eintrag) {
        this.menschBelegungen.put(Pair.create(mitarbeiter, maschinenFaehigkeit), eintrag);
    }

    public void addMaschinenBelegungsEintrag(Maschine maschine, MaschinenBelegungEintrag eintrag) {
        this.maschinenBelegungen.put(maschine, eintrag);
    }

    public void clearBelegungsEintraege() {
        this.maschinenBelegungen.clear();
        this.menschBelegungen.clear();
    }

    public BeilagenArten getBeilagenArten() {
        return this.dokumentenklassen.stream().map(dokumentenklasse -> dokumentenklasse.getVariable(BeilagenArten.class).orElse(BeilagenArten.EMPTY)).reduce(BeilagenArten.createEmpty(), (b1, b2) -> b1.addBeilagenarten(b2.getBeilagenarten()));
    }

    public LocalDateTime getFrist() {
        return this.getDokumentenklassen().stream().map(Dokumentenklasse::getFrist).min(Comparator.naturalOrder()).orElse(LocalDateTime.MAX);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProduktionsAuftrag)) {
            return false;
        }
        ProduktionsAuftrag that = (ProduktionsAuftrag)o;
        return this.dokumentenklassen.equals(that.dokumentenklassen);
    }

    public int hashCode() {
        return this.dokumentenklassen.hashCode();
    }
}

