/*
 * Decompiled with CFR 0.152.
 */
package ablaeufe.operation;

import ablaeufe.meta.Porttyp;
import ablaeufe.meta.Prozesstyp;
import ablaeufe.operation.KonsistenzVerletztException;
import ablaeufe.operation.Port;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class Prozess {
    private final List<Port> inports = new ArrayList<Port>();
    private final List<Port> outports = new ArrayList<Port>();

    protected Prozess() {
    }

    public abstract Prozesstyp getTyp();

    protected void addInport(Port port) {
        this.ueberpruefePortTypisierung(port, this.getTyp().getInporttypen(), this.inports);
        this.inports.add(port);
    }

    protected void addOutport(Port port) {
        this.ueberpruefePortTypisierung(port, this.getTyp().getOutporttypen(), this.outports);
        this.outports.add(port);
    }

    private void ueberpruefePortTypisierung(Port port, List<Porttyp> porttypen, List<Port> vorhandenePorts) {
        if (!porttypen.contains(port.getTyp())) {
            throw new KonsistenzVerletztException("Porttyp des potentiell neuen Port nicht im Prozess typisiert!");
        }
        Set belegtePorttypen = vorhandenePorts.stream().map(Port::getTyp).collect(Collectors.toSet());
        if (belegtePorttypen.contains(port.getTyp())) {
            throw new KonsistenzVerletztException("Porttyp des potentiell neuen Port bereits von einem vorhandenen Port typisiert!");
        }
    }

    public List<Port> getInports() {
        return Collections.unmodifiableList(this.inports);
    }

    public List<Port> getOutports() {
        return Collections.unmodifiableList(this.outports);
    }
}

