/*
 * Decompiled with CFR 0.152.
 */
package zeit.serientermin;

import auftraege.VoraussichtlicheDokumentenklassenVariableVisitor;
import auftraege.auftragsBildungsParameter.abstraction.VoraussichtlicheDokumentenklassenVariable;
import com.google.common.base.Objects;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import javax.measure.quantity.Time;
import tec.uom.se.ComparableQuantity;
import zeit.eintraege.KalenderEintrag;
import zeit.eintraege.Zeitraum;
import zeit.serientermin.IntervallSerienTermin;
import zeit.serientermin.MonatlicherSerientermin;

public abstract class SerienTermin
implements VoraussichtlicheDokumentenklassenVariable {
    private final KalenderEintrag eintrag;

    protected SerienTermin(KalenderEintrag eintrag) {
        this.eintrag = eintrag;
    }

    public static SerienTermin createSerienterminMitIntervall(KalenderEintrag eintrag, ComparableQuantity<Time> wiederholungsIntervall) {
        return IntervallSerienTermin.create(eintrag, wiederholungsIntervall);
    }

    public static SerienTermin createMonatlichenSerientermin(KalenderEintrag eintrag) {
        return MonatlicherSerientermin.create(eintrag);
    }

    public Collection<KalenderEintrag> getKalenderEintraegeDesSerienTerminAmTag(LocalDate tag) {
        if (this.zeitraumAmTag(this.eintrag.getZeitraum(), tag)) {
            return Collections.singleton(this.eintrag);
        }
        return this.berechneKalenderEintraegeZumTag(tag);
    }

    protected abstract Collection<KalenderEintrag> berechneKalenderEintraegeZumTag(LocalDate var1);

    protected boolean zeitraumAmTag(Zeitraum zeitraum, LocalDate tag) {
        return zeitraum.ueberschneidet(Zeitraum.createWholeDay(tag));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SerienTermin)) {
            return false;
        }
        SerienTermin that = (SerienTermin)o;
        return Objects.equal((Object)this.eintrag, (Object)that.eintrag);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.eintrag});
    }

    public KalenderEintrag getEintrag() {
        return this.eintrag;
    }

    public boolean beinhaltetZeitpunkt(LocalDateTime zeitpunkt) {
        return this.berechneKalenderEintraegeZumTag(zeitpunkt.toLocalDate()).stream().anyMatch(it -> it.getZeitraum().contains(zeitpunkt));
    }

    @Override
    public <T> T accept(VoraussichtlicheDokumentenklassenVariableVisitor<T> v) {
        return v.handle(this);
    }
}

