/*
 * Decompiled with CFR 0.152.
 */
package zeit.eintraege;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.measure.quantity.Time;
import tec.uom.se.ComparableQuantity;
import zeit.eintraege.KalenderEintrag;
import zeit.eintraege.KalenderEintragTyp;
import zeit.eintraege.KalenderEintragVisitor;

public final class KalenderEintragGenerell
extends KalenderEintrag {
    private KalenderEintragGenerell(LocalDateTime von, ComparableQuantity<Time> dauer, KalenderEintragTyp typ) {
        super(von, dauer, typ);
    }

    private KalenderEintragGenerell(LocalDateTime von, LocalDateTime bis, KalenderEintragTyp typ) {
        super(von, bis, typ);
    }

    @Override
    public <T> T accept(KalenderEintragVisitor<T> visitor) {
        return visitor.handle(this);
    }

    public static KalenderEintragGenerell create(LocalDateTime von, ComparableQuantity<Time> dauer, KalenderEintragTyp typ) {
        Objects.requireNonNull(von);
        Objects.requireNonNull(dauer);
        Objects.requireNonNull(typ);
        return new KalenderEintragGenerell(von, dauer, typ);
    }

    public static KalenderEintragGenerell create(LocalDateTime von, LocalDateTime bis, KalenderEintragTyp typ) {
        Objects.requireNonNull(von);
        Objects.requireNonNull(bis);
        Objects.requireNonNull(typ);
        if (!von.isBefore(bis)) {
            throw new IllegalArgumentException("Von-Zeitpunkt muss vor dem Bis-Zeitpunkt liegen!");
        }
        return new KalenderEintragGenerell(von, bis, typ);
    }

    public static KalenderEintragGenerell createWholeDay(LocalDate day, KalenderEintragTyp typ) {
        Objects.requireNonNull(day);
        Objects.requireNonNull(typ);
        return new KalenderEintragGenerell(day.atStartOfDay(), day.atTime(23, 59, 59), typ);
    }
}

