/*
 * Decompiled with CFR 0.152.
 */
package mensch;

import java.time.Duration;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import maschine.Maschine;
import mensch.Produktionsrolle;
import mensch.Qualifikation;
import mensch.QualifikationsException;
import mensch.faehigkeit.MitarbeiterFaehigkeit;
import mensch.faehigkeit.MitarbeiterFaehigkeitFuerMaschine;
import util.exceptions.ProduktionsrollenBereitsVorhandenException;
import zeit.Kalender;
import zeit.MitarbeiterKalender;
import zeit.TypMitKalender;
import zeit.eintraege.MenschBelegungEintrag;

public final class Mitarbeiter
implements TypMitKalender {
    private final String vorname;
    private final String name;
    private final LocalDate geburtsdatum;
    private final LocalDate eintritt;
    private final LocalDate austritt;
    private final int personalnummer;
    private final MitarbeiterKalender kalender;
    private final Collection<Produktionsrolle> produktionsrollen;
    private final Collection<Qualifikation> qualifikationen;

    private Mitarbeiter(String vorname, String name, LocalDate geburtsdatum, LocalDate eintritt, LocalDate austritt, int personalnummer, MitarbeiterKalender verfuegbarkeit) {
        this.vorname = vorname;
        this.name = name;
        this.geburtsdatum = geburtsdatum;
        this.eintritt = eintritt;
        this.austritt = austritt;
        this.personalnummer = personalnummer;
        this.kalender = verfuegbarkeit;
        this.produktionsrollen = new HashSet<Produktionsrolle>();
        this.qualifikationen = new HashSet<Qualifikation>();
    }

    public static Mitarbeiter create(String name, String vorname, LocalDate geburtsdatum, LocalDate eintritt, LocalDate austritt, int personalnummer) {
        return new Mitarbeiter(vorname, name, geburtsdatum, eintritt, austritt, personalnummer, new MitarbeiterKalender());
    }

    public Collection<Qualifikation> getQualifikationen() {
        return this.qualifikationen;
    }

    public Collection<Produktionsrolle> getProduktionsrollen() {
        return this.produktionsrollen;
    }

    private HashSet<MitarbeiterFaehigkeit> getFaehigkeiten() {
        HashSet<MitarbeiterFaehigkeit> faehigkeiten = new HashSet<MitarbeiterFaehigkeit>();
        for (Qualifikation current : this.qualifikationen) {
            faehigkeiten.add(current.getFaehigkeit());
        }
        return faehigkeiten;
    }

    public void addQualifikation(Qualifikation qualifikation) throws QualifikationsException {
        if (this.getFaehigkeiten().contains(qualifikation.getFaehigkeit())) {
            throw new QualifikationsException("Der Mitarbeiter besitzt die Qualifikation bereits!");
        }
        this.qualifikationen.add(qualifikation);
    }

    public void addQualifikation(Qualifikation ... qualifikations) throws QualifikationsException {
        for (Qualifikation qualifikation : qualifikations) {
            this.addQualifikation(qualifikation);
        }
    }

    public void addProduktionsrolle(Produktionsrolle rolle) throws ProduktionsrollenBereitsVorhandenException {
        if (this.produktionsrollen.contains(rolle)) {
            throw new ProduktionsrollenBereitsVorhandenException("Der Mitarbeiter besitzt die Rolle bereits!");
        }
        for (MitarbeiterFaehigkeit current : rolle.getFaehigkeiten()) {
            if (this.getFaehigkeiten().contains(current)) continue;
            throw new ProduktionsrollenBereitsVorhandenException("Der Mitarbeiter besitzt nicht die entsprechenden Qualifikationen f\u00fcr die Rolle!");
        }
        this.produktionsrollen.add(rolle);
    }

    public boolean kannMaschineBedienen(Maschine maschine) {
        for (Qualifikation qualifikation : this.getQualifikationen()) {
            MitarbeiterFaehigkeit faehigkeit = qualifikation.getFaehigkeit();
            if (!(faehigkeit instanceof MitarbeiterFaehigkeitFuerMaschine) || !((MitarbeiterFaehigkeitFuerMaschine)faehigkeit).getMaschinenTyp().equals(maschine.getMaschinentyp())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.personalnummer + " : " + this.vorname + " " + this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getVorname() {
        return this.vorname;
    }

    public int getPersonalnummer() {
        return this.personalnummer;
    }

    @Override
    public Kalender getKalender() {
        return this.kalender;
    }

    public boolean hatFaehigkeit(MitarbeiterFaehigkeit faehigkeit) {
        return this.getFaehigkeiten().stream().anyMatch(mitarbeiterFaehigkeit -> mitarbeiterFaehigkeit.equals(faehigkeit));
    }

    public void removeBelegungsEintrag(MenschBelegungEintrag eintrag) {
        this.getKalender().removeEintrag(eintrag);
    }

    public Set<MenschBelegungEintrag> getBelegungen() {
        return this.kalender.getBelegungen();
    }

    public LocalDate getEintritt() {
        return this.eintritt;
    }

    public LocalDate getAustritt() {
        return this.austritt;
    }

    public Duration getAlter() {
        return Duration.between(this.geburtsdatum.atStartOfDay(), LocalDate.now().atStartOfDay());
    }
}

